#!/usr/bin/env python
# Copyright (C) 2007-2009 Canonical, Ltd.
# Author: Kees Cook <kees@ubuntu.com>
#         Jamie Strandboge <jamie@canonical.com>
# License: GPLv3
import os, sys, tempfile, time
from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT
from launchpadlib.credentials import Credentials
from launchpadlib.errors import HTTPError

def connect():
    cachedir = os.path.expanduser('~/.launchpadlib/cache')
    if not os.path.exists(cachedir):
        os.makedirs(cachedir,0700)

    credfile = os.path.expanduser('~/.launchpadlib/credentials')
    try:
        credentials = Credentials()
        credentials.load(open(credfile))
        launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
    except:
        launchpad = Launchpad.get_token_and_login(sys.argv[0], EDGE_SERVICE_ROOT, cachedir)
        credfd = tempfile.NamedTemporaryFile(dir=os.path.dirname(credfile))
        launchpad.credentials.save(credfd)
        os.link(credfd.name, credfile)
        credfd.close()
    return launchpad

def save(item):
    # attempt to deal with intermittent failures
    count = 0
    max_tries = 10
    result = False
    err_str = ""
    while not result and count < max_tries:
        try:
            item.lp_save()
            result = True
        except HTTPError, error:
            err_str = "save() failed: %s" % (error.content)
            count += 1
            time.sleep(5)

    if not result:
        print >>sys.stderr, "%s (tried %d times)" % (err_str, max_tries)
    return result

def extract_task(task):
    name = task.bug_target_name.lower()
    package = None
    distribution = None
    series = None
    if ' (' in name:
        package, distribution = name.split(' (',1)
        distribution = distribution.split(')')[0]
        if ' ' in distribution:
            distribution, series = distribution.split(' ',1)
    else:
        package = name

    return package, distribution, series
