#include <config.h>
#include "ucarp.h"
#include "fillmac.h"
#include <sys/ioctl.h>
#ifdef HAVE_IFADDRS_H
# include <ifaddrs.h>
#endif
#ifdef HAVE_NET_IF_DL_H
# include <net/if_dl.h>
#endif
#ifdef HAVE_NET_IF_TYPES_H
# include <net/if_types.h>
#endif

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

int fill_mac_address(void)
{
    int s;
    
    if ((s = socket(PF_INET, SOCK_DGRAM, 0)) == -1) {
        perror("socket");
        return -1;
    }
#ifdef SIOCGIFHWADDR
    {
	struct ifreq ifr;
	
	if (strlen(interface) >= sizeof ifr.ifr_name) {
	    fprintf(stderr, "Interface name too long\n");
	    return -1;
	}
	strcpy(ifr.ifr_name, interface);            	
        if (ioctl(s, SIOCGIFHWADDR, &ifr) != 0) {
            perror("SIOCGIFHWADDR");
            (void) close(s);
            return -1;
        }
        switch (ifr.ifr_hwaddr.sa_family) {
        case ARPHRD_ETHER:
        case ARPHRD_IEEE802:
            break;
        default:
            fprintf(stderr, "Warning : unknown hardware type [%u]\n",
                    (unsigned int) ifr.ifr_hwaddr.sa_family);
        }
        memcpy(hwaddr, &ifr.ifr_hwaddr.sa_data, sizeof hwaddr);
    }
#elif defined(HAVE_GETIFADDRS)
    {	
	struct ifaddrs *ifas;
	struct ifaddrs *ifa;
	struct sockaddr_dl *sadl;
	struct ether_addr *ea;
	
	if (getifaddrs(&ifas) != 0) {
	    perror("getifaddrs");
	    return -1;
	}
	ifa = ifas;
	while (ifa != NULL) {
	    if (strcmp(ifa->ifa_name, interface) == 0 &&
		ifa->ifa_addr->sa_family == AF_LINK) {
		sadl = (struct sockaddr_dl *) ifa->ifa_addr;
		if (sadl == NULL || sadl->sdl_type != IFT_ETHER ||
		    sadl->sdl_alen <= 0) {
		    fprintf(stderr,
			    "Invalid media / hardware address for [%s]\n",
			    interface);
		    return -1;
		}
		ea = (struct ether_addr *) LLADDR(sadl);
		memcpy(hwaddr, ea, sizeof hwaddr);
                
		return 0;
	    }
	    ifa = ifa->ifa_next;
	}
	return -1;
    }
#endif
    
    (void) close(s);    
    
    return 0;
}
