#include "cs.h"
/* x=A\b where A is unsymmetric; b overwritten with solution */
CS_INT cs_lusol (const cs *A, CS_ENTRY *b, CS_INT order, double tol)
{
    CS_ENTRY *x ;
    css *S ;
    csn *N ;
    CS_INT n, ok ;
    if (!A || !b) return (0) ;		/* check inputs */
    n = A->n ;
    S = cs_sqr (A, order, 0) ;		/* ordering and symbolic analysis */
    N = cs_lu (A, S, tol) ;		/* numeric LU factorization */
    x = cs_malloc (n, sizeof (CS_ENTRY)) ;
    ok = (S && N && x) ;
    if (ok)
    {
	cs_ipvec (n, N->Pinv, b, x) ;	/* x = P*b */
	cs_lsolve (N->L, x) ;		/* x = L\x */
	cs_usolve (N->U, x) ;		/* x = U\x */
	cs_ipvec (n, S->Q, x, b) ;	/* b = Q*x */
    }
    cs_free (x) ;
    cs_sfree (S) ;
    cs_nfree (N) ;
    return (ok) ;
}
