% UFTRACE(1) Uftrace User Manuals
% Namhyung Kim <namhyung@gmail.com>
% Sep, 2018

NAME
====
uftrace - Function graph tracer for userspace


SYNOPSIS
========
uftrace [*record*|*replay*|*live*|*report*|*info*|*dump*|*recv*|*graph*|*script*|*tui*] [*options*] COMMAND [*command-options*]


DESCRIPTION
===========
The uftrace tool is a function tracer that traces the execution of given
`COMMAND` at the function level.  `COMMAND` should be a C or C++ executable
built with compiler instrumentation (`-pg` or `-finstrument-functions`).
COMMAND needs to have an ELF symbol table (i.e. not be `strip`(1)-ed) in order
for the names of traced functions to be available.

The uftrace command consists of a number of sub-commands, in the manner of
`git`(1) or `perf`(1).  Below is a short description of each sub-command.
For more detailed information, see the respective manual pages.  The options
in this page can be given to any sub-command also.

For convenience, if no sub-command is given, uftrace acts as though the `live`
sub-command was specified, which runs the `record` and `replay` sub-commands in
turn.  See `uftrace-live`(1) for options belonging to the `live` sub-command.
For more detailed analysis, it is better to use `uftrace-record`(1) to save
trace data, and then analyze it with other uftrace commands like
`uftrace-replay`(1), `uftrace-report`(1), `uftrace-info`(1), `uftrace-dump`(1),
`uftrace-script`(1) or `uftrace-tui`(1).


SUB-COMMANDS
============
record
:   Run a given command and save trace data in a data file or directory.

replay
:   Print recorded function trace data with time durations.

live
:   Do live tracing.  Print function trace of the given command.

report
:   Print various statistics and summary of the recorded trace data.

info
:   Print side-band information like OS version, CPU info, command line and so on.

dump
:   Print raw tracing data in the data files.

recv
:   Save tracing data sent to network

graph
:   Print function call graph

script
:   Run a script for recorded function trace

tui
:   Show text user interface for graph and report

[//1]: # "This is a portable invisible comment block as outlined in this answer:"
[//2]: # "https://stackoverflow.com/questions/4823468/comments-in-markdown"

[//3]: # "Most of the command line option help texts have been generated by:"
[//4]: # "https://github.com/bernhardkaindl/help2md"
[//5]: # "(followed by merging the existing more descriptive option help texts)"
[//6]: # "TODO: Group them into command-specific sections for a quick overview"
[//7]: # "with a note referring to the command-specific page for each section."
[//8]: # "While they are described in the command-specific pages, it"
[//9]: # "would be nice to also have one place to check for all options."


COMMON OPTIONS
==============
These are the common options supported by all uftrace subcommands:

-h, \--help
:   Print help message and list of options with description

\--usage
:   Print usage string

-V, \--version
:   Print program version

-v, \--verbose
:   Print verbose messages.  This option increases a debug level and can be
    used at most 3 times.

\--debug
:   Print debug messages.  This option is same as `-v`/`--verbose` and is
    provided only for backward compatibility.

\--debug-domain=*DOMAIN*[,*DOMAIN*, ...]
:   Limit the printing of debug messages to those belonging to one of the
    DOMAINs specified.  Available domains are: uftrace, symbol, demangle,
    filter, fstack, session, kernel, mcount, dynamic, event, script and dwarf.
    The domains can have an their own debug level optionally (preceded by a
    colon).  For example, `-v --debug-domain=filter:2` will apply debug level
    of 2 to the "filter" domain and apply debug level of 1 to others.

-d *DATA*, \--data=*DATA*
:   Specify name of trace data (directory).  Default is `uftrace.data`.

\--logfile=*FILE*
:   Save warning and debug messages into this file instead of stderr.

\--color=*VAL*
:   Enable or disable color on the output.  Possible values are
    "yes"(= "true" | "1" | "on" ), "no"(= "false" | "0" | "off" ) and "auto".
    The "auto" value is default and turns on coloring if stdout is a terminal.

\--no-pager
:   Do not use a pager.

\--opt-file=*FILE*
:   Read command-line options from the FILE.


SUBCOMMAND-SPECIFIC OPTIONS
===========================
These options are listed here for completeness, but are only effective with specific
subcommands.

Please see the uftrace-<*subcommand*> manual pages for more information:
The manual for *uftrace-live*(1) is special: The subcommand `live` does
record and `replay` internally. Thus, it describes most regular option in detail.

\--avg-self
:   Show average/min/max of self function time

\--avg-total
:   Show average/min/max of total function time

-a, \--auto-args
:   Show arguments and return value of known functions

-A, \--argument=*FUNC*@arg[,arg,...]
:   Show function arguments

-b, \--buffer=*SIZE*
:   Size of tracing buffer (default: 128K)

\--chrome
:   Dump recorded data in chrome trace format

\--clock
:   Set clock source for timestamp (default: mono)

\--column-offset=*DEPTH*
:   Offset of each column (default: 8)

\--column-view
:   Print tasks in separate columns

-C, \--caller-filter=*FUNC*
:   Only trace callers of those FUNCs

\--demangle=*TYPE*
:   C++ symbol demangling: full, simple, no
:   (default: simple)

\--diff=*DATA*
:   Report differences

\--diff-policy=*POLICY*
:   Control diff report policy
:   (default: 'abs,compact,no-percent')

\--disable
:   Start with tracing disabled

-D, \--depth=*DEPTH*
:   Trace functions within *DEPTH*

-e, \--estimate-return
:   Use only entry record type for safety

\--event-full
:   Show all events outside of function

-E, \--Event=*EVENT*
:   Enable *EVENT* to save more information

\--flame-graph
:   Dump recorded data in FlameGraph format

\--flat
:   Use flat output format

\--force
:   Trace even if executable is not instrumented

\--format=*FORMAT*
:   Use *FORMAT* for output: normal, html (default: normal)

-f, \--output-fields=*FIELD*
:   Show FIELDs in the replay or graph output

-F, \--filter=*FUNC*
:   Only trace those FUNCs

-g, \--agent
:   Start an agent in mcount to listen to commands

\--graphviz
:   Dump recorded data in *DOT* format

-H, \--hide=*FUNC*
:   Hide FUNCs from trace

\--host=*HOST*
:   Send trace data to *HOST* instead of write to file

-k, \--kernel
:   Trace kernel functions also (if supported)

\--keep-pid
:   Keep same pid during execution of traced program

\--kernel-buffer=*SIZE*
:   Size of kernel tracing buffer (default: 1408K)

\--kernel-full
:   Show kernel functions outside of user

\--kernel-only
:   Dump kernel data only

\--kernel-skip-out
:   Skip kernel functions outside of user (deprecated)

-K, \--kernel-depth=*DEPTH*
:   Trace kernel functions within *DEPTH*

\--libmcount-single
:   Use single thread version of libmcount

\--list-event
:   List available events

\--logfile=*FILE*
:   Save warning and debug messages into this file instead of stderr.

-l, \--nest-libcall
:   Show nested library calls

\--libname
:   Show libname name with symbol name

\--libmcount-path=*PATH*
:   Load libmcount libraries from this *PATH*

\--match=*TYPE*
:   Support pattern match: regex, glob (default:
:   regex)

\--max-stack=*DEPTH*
:   Set max stack depth to *DEPTH* (default: 65535)

\--no-args
:   Do not show arguments and return value

\--no-comment
:   Don't show comments of returned functions

\--no-event
:   Disable (default) events

\--no-sched
:   Disable schedule events

\--no-sched-preempt
:   Hide pre-emptive schedule event
:   but show regular(sleeping) schedule event

\--no-libcall
:   Don't trace library function calls

\--no-merge
:   Don't merge leaf functions

\--no-pltbind
:   Do not bind dynamic symbols (*LD_BIND_NOT*)

\--no-randomize-addr
:   Disable *ASLR* (Address Space Layout Randomization)

\--nop
:   No operation (for performance test)

\--num-thread=*NUM*
:   Create *NUM* recorder threads

-N, \--notrace=*FUNC*
:   Don't trace those FUNCs

-p, \--pid=*PID*
:   Connect to the *PID* of an interactive mcount instance

\--port=*PORT*
:   Use *PORT* for network connection (default: 8090)

-P, \--patch=*FUNC*
:   Apply dynamic patching for FUNCs

\--record
:   Record a new trace before running given script

\--report
:   Show a live report before replay

\--rt-prio=*PRIO*
:   Record with real-time (*FIFO*) priority

-r, \--time-range=*TIME*~*TIME* Show output within the *TIME*(timestamp or elapsed time)
:   range only

\--run-cmd=*CMDLINE*
:   Command line that want to execute after tracing
:   data received

-R, \--retval=*FUNC*[@retspec]
:   Show function return values for *FUNC*, optionally with given uftrace retspec

\--sample-time=*TIME*
:   Show flame graph with this sampling time

\--signal=*SIGNAL*@act[,act,...]
:   Trigger the given actions when the given *SIGNAL* is received

\--sort-column=*INDEX*
:   Sort diff report on column *INDEX* (default: 2)

\--srcline
:   Enable recording source line info

\--symbols
:   Print symbol table instead of the recorded tracing info

-s, \--sort=*KEY*[,*KEY*,...]
:   Sort reported functions by KEYs (default: 2)

-S, \--script=*SCRIPT*
:   Run a given *SCRIPT* in function entry and exit

-t, \--time-filter=*TIME*
:   Hide small functions run less than the *TIME*

\--task
:   [info]: Print task relationship in a tree form instead of the tracing info.

\--task-newline
:   Interleave a newline when task is changed

\--tid=*TID*[,*TID*,...]
:   Only replay those tasks

\--time
:   Print time information

-T, \--trigger=*FUNC*@act[,act,...]
:   Trigger action on those FUNCs

-U, \--unpatch=*FUNC*
:   Don't apply dynamic patching for FUNCs

\--with-syms=*DIR*
:   Use symbol files in the *DIR*

-W, \--watch=*POINT*
:   Watch and report *POINT* if it's changed

-Z, \--size-filter=*SIZE*
:   Apply dynamic patching for functions bigger than *SIZE*

For more detail about these command-specific options,
please see the more specific manual pages listed below.


SEE ALSO
========
`uftrace-live`(1), `uftrace-record`(1), `uftrace-replay`(1), `uftrace-report`(1), `uftrace-info`(1), `uftrace-dump`(1), `uftrace-recv`(1), `uftrace-graph`(1), `uftrace-script`(1), `uftrace-tui(1)`
