U_GLOBAL = new Object();

U_GLOBAL.name     = 'CDD';
U_GLOBAL.type     = 'http_annotator';
U_GLOBAL.alphabet = 'amino';
U_GLOBAL.strand   = 'single';
U_GLOBAL.annotations = [];
U_GLOBAL.max_query_len = 2000;

maxhits = 100;
evalue  = 0.01;
filter  = 'true';

HOST_URL  = 'http://www.ncbi.nlm.nih.gov/Structure/cdd/wrpsb.cgi';

QUERY_URL = HOST_URL + '?db=cdd&maxhits=' + maxhits + '&evalue=' + evalue + '&filter=' + filter + '&seqinput=';
RES_URL   = HOST_URL + '?rid=';

LOADING_STR = '<title>Loading...</title>';
RESULTS_STR = '<title>NCBI Conserved Domain Search</title>';

TOK_CELL_O = '<td>';
TOK_CELL_C = '</td>';

TOK_ROW_O  = '<tr>';
TOK_ROW_C  = '</tr>';


RID = '';
RTOE = 10;

// enum
QBEGIN = 0;
QEND   = 1;
RBEGIN = 2;
REND   = 3;

function createSearchRegexp( text ) {
    var p = (PTR).toString();
    return new RegExp( '\\s*[\\w\\W]{' + p + ',' + p + '}\\s*' + text, 'g' );
}    

function dataBetweenTags( left, right ) {
    var dataStart = TABLE.indexOf( left, PTR );
    if( -1 == dataStart ) {
        throw 'dataBetweenTags: cannot find starting tag ' + left;
    }
    PTR = dataStart + left.length;
   
    var dataEnd = TABLE.indexOf( right, PTR );
    if( -1 == dataEnd ) {
       throw 'dataBetweenTags: cannot find closing tag ' + right;
    }
    var data = TABLE.substring( PTR, dataEnd );
    PTR = dataEnd + right.length;
    return data;
}

function parseBigTable() {
    var table = dataBetweenTags( '<td><TABLE>', '</TABLE>\n</td>' );
    var entries = table.split( /<\/pre><\/td><\/tr>\s*<tr><td><pre>/ );
  

    var rgxp = /[\w\W]*<\/a>\s*<[\w\W]*>\s*(\d+)\s*<[\w\W]*>\s*(\d+)\s*<\/font>[\w\W]*<\/a>\s*<[\w\W]*>\s*(\d+)\s*<[\w\W]*>\s*(\d+)\s*<\/font>/;

    var first_res = rgxp.exec( entries[0] );
    var last_res = rgxp.exec( entries[entries.length-1] );
    
    if( null != first_res && null != last_res && 5 == first_res.length && 5 == last_res.length ){
        var ret = [];
        ret[QBEGIN] = first_res[1];
        ret[RBEGIN] = first_res[3];
        ret[QEND]   = last_res[2];
        ret[REND]   = last_res[4];
        return ret;
    }


    return null;
}

function parseTd() {
    return dataBetweenTags( TOK_CELL_O, TOK_CELL_C );    
}

function restorePos( pos ) {
    for( i = 0; i < STARS.length; ++i ) {
        if( STARS[i] <= pos ) {
            pos++;
        }
    }    
    return pos;
}

function parseRow() {
    var p = PTR.toString();
    var beginInd = TABLE.indexOf( TOK_ROW_O, PTR );
    if( -1 == beginInd ) {
        return null;
    }    
    PTR = beginInd + TOK_ROW_O.length;
    var ad = new U_GLOBAL.AnnotationData();

        ad.addQualifier( 'PssmId',     parseTd() );
        ad.addQualifier( 'id',         parseTd() );
        ad.name =                      parseTd() ;
        ad.addQualifier( 'description',parseTd() );
        parseTd(); //short description, included in previous
        parseTd(); //flag, true if this entry should be shown in concise display
        ad.addQualifier( 'multiDom',   parseTd() );
        parseTd(); //something included in previous
        ad.addQualifier( 'CD length',  parseTd() );
        ad.addQualifier( 'E-value',    parseTd() );
        ad.addQualifier( 'bit score',  parseTd() );
//        ad.addQualifier( '???',        parseTd() );
        parseTd();


        var loc = parseBigTable();
        if( null == loc/* || 4 != loc.length*/ ) {
            throw 'cannot parse location';
        }
        var qbegin = restorePos( loc[QBEGIN] );
        var qend = restorePos( loc[QEND] );
        ad.addLocation( qbegin - 1, qend - qbegin + 1 ); //-1 because of script should return 0-based offsets
        ad.addQualifier( 'hit-from', loc[RBEGIN] );
        ad.addQualifier( 'hit-to',   loc[REND] );
  
        var tmp = parseTd();
        if( '' != tmp ) {
//            ad.addQualifier( '???1', tmp  ); //superfamily?
        }
        tmp = parseTd();
        if( '' != tmp ) {
//           ad.addQualifier( '???2', tmp  ); //superfamily id?
        }

        tmp = parseTd();
        if( '' != tmp ) {
//            ad.addQualifier( '???3', tmp  ); //superfamily name?
        }

        tmp = parseTd();
        if( '' != tmp ) {
//            ad.addQualifier( '???4', tmp  ); //superfamily long desc?
        }

        parseTd(); //short desc
        parseTd(); //unknown
        
    var endInd = TABLE.indexOf( TOK_ROW_C, PTR );
    if( -1 == endInd ) {
        throw 'cannot find ' + TOK_ROW_C;
    }
    PTR = endInd + TOK_ROW_C.length;
    return ad;
}

function parseTable() {
    PTR = 0;  
    var result = [];
    var added = 0;
    var skipped = 0;
    while( true ) {
        var ad = parseRow();
        if( null == ad ) {
            return result;
        }
        var ad_len = ad.getSummaryLen();
        if( ad_len <= U_GLOBAL.max_res_len && ad_len >= U_GLOBAL.min_res_len ) 
        {
            ad.name = 'Domain hit';
            ad.setAlpha( true );
            result.push( ad );
            ++added;
            U_GLOBAL.log.debug( 'cdd hit added' );
        } else {
            U_GLOBAL.log.debug( 'HSP skipped due to length limitations, hsp length is: ' + ad_len );
            ++skipped;
        }
    }
    U_GLOBAL.log.info( 'TOTAL: ' + added + ' added ' + ', ' + skipped + ' skipped' );
}

function extractTable() {
    var tableBegin = '<table id=\"cd_data_table\">';
    var tableEnd   = '\\s*</table>';

    var start = FULL_TEXT.search( tableBegin );
    var tmp = FULL_TEXT.substring( start );
    var end = tmp.search( tableEnd );

    TABLE = tmp.substring( tableBegin.length, end );    
}


function readResults() {
    extractTable();
    FULL_TEXT = null;
    if( '' == TABLE ) {
        U_GLOBAL.log.info( 'server reports no results' );
        return;
    }
    U_GLOBAL.annotations = parseTable();  
}

function tryGetRid() {
    var rid_regexp = /RID\s*=\s*([\w\-\.]*)/;
    var res = rid_regexp.exec(FULL_TEXT);
    if( null != res && res.length > 1 ) {
        RID = res[1];
    } else {
        throw 'cannot obtain request id';
    }
}

function isLoading() {
    return -1 != FULL_TEXT.search( LOADING_STR );
}

function isReady() {
    return -1 != FULL_TEXT.search( RESULTS_STR );
}

function tryGetResults() {
    var fullUrl = RES_URL + RID;
    var response = U_GLOBAL.get( fullUrl );

    if( isLoading() ) {
        return;
    } else if( isReady() ) {
//        timer.timeout.disconnect( tryGetResults );
        timer.stop();
        readResults();
    } else {
        LOOP.exit();
        throw 'cannot resolve server response';
    }
}

function findStarsInQuery() {
    STARS = [];
    var qstr = U_GLOBAL.query.toString();
    for( i = 0; i < qstr.length; ++i ) {
        if( '*' == qstr.charAt(i) ){
            STARS.push(i+1); //+1 because of server returns 1-based offsets
        }                
    }
}

U_GLOBAL.main = function() {
    LOOP = new QEventLoop();
    U_GLOBAL.log.info( 'CDD script: preparing...' );
    findStarsInQuery();
    var fullUrl = QUERY_URL + '>lcl|local\n' + U_GLOBAL.query;
    U_GLOBAL.log.debug( 'query size: ' + U_GLOBAL.query.toString().length );
    U_GLOBAL.log.info( 'request queued to ' + HOST_URL + '...' );
    U_GLOBAL.stateInfo.stateDesc = 'waiting for server response';
    
    FULL_TEXT = U_GLOBAL.get( fullUrl ).toString();
//    FULL_TEXT = U_GLOBAL.get( "http:\/\/localhost\/stuff\/cdd_new.html" ).toString();

    if( isLoading() ) {
        U_GLOBAL.log.info( 'waiting ' + RTOE + ' sec ...' );
        U_GLOBAL.stateInfo.stateDesc = 'waiting for search results';
        tryGetRid();
        U_GLOBAL.log.info( 'request ID: ' + RID );

        timer = new QTimer();
        timer.singleShot = false;
        timer.timeout.connect( tryGetResults );
        timer.start( RTOE * 1000 ); 
        LOOP.exec();
    } else if( isReady() ){
        U_GLOBAL.log.info( 'seems like data is ready, trying to parse response' );
        U_GLOBAL.stateInfo.stateDesc = 'parsing results';
        readResults();
    } else {
        throw 'cannot resolve server response';
    }
}
