/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DBXRefRegistry.h"
#include "Log.h"

#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtGui/QApplication>

namespace GB2 {

static LogCategory log(ULOG_CAT_CORE_SERVICES);

#define DB_XREF_FILE_NAME "DBXRefRegistry.txt"

DBXRefRegistry::DBXRefRegistry(QObject *p) : QObject(p) {
    QFile file;
    file.setFileName(QApplication::applicationDirPath()+"/data/" + DB_XREF_FILE_NAME);
    if(!file.exists()) {
        file.setFileName(QApplication::applicationDirPath()+"/../../data/"+DB_XREF_FILE_NAME);
    }
    if(!file.exists() || !file.open(QIODevice::ReadOnly)){
        log.error(tr("dbxref_file_not_found_%1").arg(DB_XREF_FILE_NAME));
        return;
    } 
    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine();
        if(line.length()==0 || line.startsWith("#")) {
            continue;
        }
        QStringList fields = line.split("|");
        if (fields.size()!=4) {
            log.error(tr("illegal_entry_%1").arg(line));
            continue;
        }
        DBXRefInfo info(fields[0], fields[1], fields[2],fields[3].trimmed());
        refsByKey[info.name] = info;
    }
    file.close();
}

}//namespace
