/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_NETWORK_CONFIGURATION_H_
#define _GB2_NETWORK_CONFIGURATION_H_


#include <QtNetwork/QNetworkProxy>
#include <QtCore/QStringList>
#include <QtCore/QMap>
#include "core_api.h"

class QUrl;
class QString;

namespace GB2
{
typedef QNetworkProxy::ProxyType Proxy_t;

class GB2_COREAPI_EXPORT ProxyConfig
{
public:
    ProxyConfig(): excepted_addr_enabled(false){}
    QMap< Proxy_t, QNetworkProxy > proxyz; //only one proxy for each type
    QMap< Proxy_t, bool > proxyz_usage; //true if proxy is used
    QStringList excepted_addr;
    bool excepted_addr_enabled;
};

class GB2_COREAPI_EXPORT NetworkConfiguration
{
public:
    NetworkConfiguration();
    ~NetworkConfiguration();
    QNetworkProxy   getProxyByUrl( const QUrl & url ) const;
    QNetworkProxy   getProxy( Proxy_t prtype ) const;
    bool            isProxyUsed( Proxy_t prtype ) const;
    void            removeProxy( Proxy_t prtype);
    int             addProxy( const QNetworkProxy & p_ ); //returns non-zero if replacing
    void            setProxyUsed( Proxy_t prtype, bool val );
    void            setExceptionsList( const QStringList & exc_addr );
    QStringList     getExceptionsList() const {return pc.excepted_addr; }
    bool            exceptionsEnabled() const {return pc.excepted_addr_enabled;}
    void            setExceptionsEnabled( bool st ) {pc.excepted_addr_enabled = st; }    
    void            copyFrom(const NetworkConfiguration& image);
private:
    static Proxy_t url2type( const QUrl & url );
    ProxyConfig pc;
};

} //namespace

#endif
