/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SCRIPT_REGISTRY_H_
#define _GB2_SCRIPT_REGISTRY_H_

#include <QtCore/QString>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QVariant>
#include <QtScript/QScriptEngine>
#include <QtScript/QScriptValue>

#include "core_api.h"
#include <core_api/ServiceModel.h>
#include <core_api/PluginModel.h>
#include <core_api/Task.h>

namespace GB2
{
class Settings;

enum ScriptState {
    ScriptState_Invalid = -1,
    ScriptState_Unloaded,
    ScriptState_Ready
};

class GB2_COREAPI_EXPORT Script {
public:
    Script( const QString & _url );

    QString     getName() const {return name;}
    QString     getType() const {return type;}
    QString     getUrl() const {return url;}
    ScriptState getState() const {return state;}
    QString     getStateString() const;

    inline bool isReady() const {return ScriptState_Ready == state; }
    inline bool isInvalid() const {return ScriptState_Invalid == state ;}
    inline bool isUnloaded() const {return ScriptState_Unloaded == state;}

    bool        reload();

    bool        init_engine( QScriptEngine * eng, QScriptValue * exception = 0 );
    static void importExtensions( QScriptEngine * eng );
    static QScriptValue getGlobal( QScriptEngine * eng );
//    QScriptValue executeMain( QScriptEngine * eng, QScriptValue & exception = QScriptValue()  ); 
//    QScriptValue execute( QScriptEngine * eng, const QString & text, QScriptValue & exception = QScriptValue()  );

    QScriptValue callMain( QScriptEngine * eng, QScriptValue * exception = 0 );
    QScriptValue callConfigure( QScriptEngine * eng, QScriptValue * exception = 0  );
    QScriptValue callSetup( QScriptEngine * eng, QScriptValue * exception = 0 );

    void saveCustomSettings( Settings * settings, const QString & path ) const;
    void loadCustomSettings( Settings * settings, const QString & path );
private:
    static QScriptValue callFunction( QScriptEngine * eng, const QString & name, QScriptValue * exception = 0,
                                      const QScriptValueList * arguments = 0 );
    ScriptState state;
    QString url;
    QString text;

    QString name; 
    QString type;
    QVariantMap custom_props;
};


class ScriptRegistryService;
class ScriptRegistryEnableTask : public Task {
    Q_OBJECT
public:
    ScriptRegistryEnableTask( ScriptRegistryService * srs );
    void run();
private:
    ScriptRegistryService * srs;
};


class GB2_COREAPI_EXPORT ScriptRegistryService : public Service{
    friend class ScriptRegistryEnableTask;
    Q_OBJECT
public:
    ScriptRegistryService( Plugin * p );
    ~ScriptRegistryService();
    Script*             registerScript(const QString& url);
    void                unregisterScript( Script * scr );
    QList<Script *>     getScriptsByType( const QString & type ) const;
    Script *            getScript( const QString & name, const QString & type ) const;
    QList<Script *>     getAllScripts() const {return scripts;}

    virtual Task * createServiceEnablingTask() {return new ScriptRegistryEnableTask(this);}
private:
    Script * findByUrl( const QString & url );
    void loadScripts();
    QList<Script *> scripts;

    static const char * SETTINGS_SCRIPT_URLS;
    static const char * SETTINGS_SCRIPT_CUSTOM_SETTINGS;
};


} //namespace

#endif
