/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PDB_FORMAT_H_
#define _GB2_PDB_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>
#include <QtCore/QSharedDataPointer>

namespace GB2 {

class IOAdapter;
class BioStruct3D;
class AnnotationTableObject;
class DNASequenceObject;
class AtomData;
typedef QSharedDataPointer<AtomData> SharedAtom;



class GB2_COREAPI_EXPORT  PDBFormat : public DocumentFormat {
	Q_OBJECT
public:
	PDBFormat(QObject* p);
	virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::PLAIN_PDB;}
	virtual const QString& getFormatName() const {return formatName;}
	virtual QStringList getSupportedDocumentFileExtensions();
	virtual Document* loadExistingDocument(IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs);
    virtual void storeDocument(Document* d, TaskStateInfo& ti, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null);
	virtual bool isObjectOpSupported(const Document* d , DocumentFormat::DocObjectOp op, GObjectType t) const;
	virtual bool isDataFormatSupported(const char* data, int size) const;
	virtual bool checkConstraints(const DocumentFormatConstraints& c) const;
	static int getElementNumberByName(const QByteArray& elementName);
	static double getAtomCovalentRadius(int atomicNumber);
    static QChar getAcronymByName(const QByteArray& name);


private:
    static const int NUM_ELEMENTS = 120; 
    QString formatName;
	static QHash<QByteArray,int> atomNumMap;
	static QHash<QByteArray, QChar> acronymNameMap;
	static double atomRadiusTable[NUM_ELEMENTS];
    
    void initUtilityMaps();
    DNASequenceObject* createSequenceObject( const QByteArray& seq, const QByteArray& sequenceName);
    void calculateBonds(BioStruct3D& bioStruct);
    void fillBioStruct3DAnnotationTable(AnnotationTableObject* ao, const BioStruct3D& bioStruct);
	
	
	class PDBParser { 
	private:
		// Data
        IOAdapter *io;
		QString currentPDBLine;
		QChar currentChainId;
		int currentMoleculeId;
        bool flagMultipleModels;
		bool flagAtomRecordPresent, flagSequenceRecordPresent;
		QHash<QChar, int> chainIndexMap;
        QMap<int, int> residueStartIndexMap;
        QMap<int, int> unreferencedResidueStartIndexMap;
        QVariantMap currentMoleculeDescr;
		// Methods
        QByteArray getSpecValue(const QByteArray& specLine, const QByteArray& valueName);
        int getChainIndexByName(const QChar& chainId);
        void parseHeader(BioStruct3D& biostruct, TaskStateInfo& ti);
		void parseCompound(BioStruct3D& biostruct, TaskStateInfo& ti);
		void parseDBRef(BioStruct3D& biostruct, TaskStateInfo& ti);
        void parseSequence(BioStruct3D& biostruct, TaskStateInfo& ti);
		void parseSecondaryStructure(BioStruct3D& biostruct, TaskStateInfo& ti);
		void parseHet(BioStruct3D& biostruct, TaskStateInfo& ti);
		void parseAtomConnections(BioStruct3D& biostruct, TaskStateInfo& ti);
		void parseAtom(BioStruct3D& biostruct, TaskStateInfo& ti);
        QByteArray getNextSpecLine();
	public:
		PDBParser(IOAdapter* io);
		void parseBioStruct3D(BioStruct3D& biostruct, TaskStateInfo& ts);
	};

};

}//namespace

#endif
