/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_STOCKHOLM_FORMAT_H_
#define _GB2_STOCKHOLM_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class IOAdapter;
	
class GB2_COREAPI_EXPORT StockholmFormat : public DocumentFormat {
    Q_OBJECT
private:
    QString format_name;
	
public:
	StockholmFormat( QObject* obj );

    virtual DocumentFormatId getFormatId() const {
        return BaseDocumentFormats::STOCKHOLM;
    }

    virtual const QString& getFormatName() const {
        return format_name;
    }

    virtual QStringList getSupportedDocumentFileExtensions();

    virtual Document* loadExistingDocument( IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs );

    virtual void storeDocument( Document* d, TaskStateInfo& ti, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null );

    virtual bool isDataFormatSupported( const char* data, int size ) const;

    virtual bool isObjectOpSupported( const Document* d , DocumentFormat::DocObjectOp op, GObjectType t ) const;

    virtual bool checkConstraints( const DocumentFormatConstraints& c ) const;
	
    //exceptions
    struct StockholmBaseException {
        QString msg;
        StockholmBaseException( const QString& str ): msg( str ){}
    };
    struct ReadError : public StockholmBaseException {
        ReadError(): StockholmBaseException( QObject::tr( "read error occurred" ) ){}
    };
    struct WriteError: public StockholmBaseException {
        WriteError(): StockholmBaseException( QObject::tr( "write error occurred" ) ){}
    };
    struct BadFileData : public StockholmBaseException {
        BadFileData( const QString& msg ): StockholmBaseException( msg ){}
    };
	
}; // StockholmFormat

} // namespace


#endif //_GB2_STOCKHOLM_FORMAT_H_
