/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SELECTION_UTILS_H_
#define _GB2_SELECTION_UTILS_H_

#include "SelectionTypes.h"
#include <core_api/LRegion.h>
#include <core_api/SelectionModel.h>
#include <QtCore/QSet>

namespace GB2 {

class GObject;
class Document;

class GB2_COREAPI_EXPORT SelectionUtils {
public:
	
	static QSet<GObject*>	findObjects(GObjectType t, const MultiGSelection* s);
	
	static QSet<GObject*>	findObjects(GObjectType t, const GSelection* s);
	
	static QSet<Document*>	findDocumentsWithObjects(GObjectType t, const MultiGSelection* s, 
		bool checkDocFormatsForUnloadedDocs,
		bool deriveDocsFromObjectSelection);
	
	static QSet<Document*>	findDocumentsWithObjects(GObjectType t, const GSelection* s, 
		bool checkDocFormatsForUnloadedDocs, 
		bool deriveDocsFromObjectSelection);


	static bool isDocumentInSelection(const Document* doc, const MultiGSelection& ms, bool deriveDocsFromObjectSelection);

	static QList<Document*> getSelectedDocs(const MultiGSelection& ms);

	static QList<GObject*> getSelectedObjects(const MultiGSelection& ms);

    //todo: find a better place: like DNAUtils..
    static LRegion normalizeRegionBy3(LRegion reg, int seqLen, bool direct);
};




}//namespace

#endif

