/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEST_FRAMWORK_COMPONENTS_
#define _GB2_TEST_FRAMWORK_COMPONENTS_

#include "GTest.h"

namespace GB2 {

class GB2_COREAPI_EXPORT GTestFormatRegistry : public QObject {
    Q_OBJECT
public:
    GTestFormatRegistry();
    ~GTestFormatRegistry();
    
    bool registerTestFormat(GTestFormat* f);

    bool unregisterTestFormat(GTestFormat* f);

    QList<GTestFormat*> getFormats() const {return formats;}

    GTestFormat* findFormat(const GTestFormatId& id);

private:
    QList<GTestFormat*> formats;

};

class GB2_COREAPI_EXPORT TestFramework {
public:
    GTestFormatRegistry* getTestFormatRegistry() {return &formatRegistry;}

private:
    GTestFormatRegistry formatRegistry;
};

}//namespace

#endif
