/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_OBJECT_TESTS_H_
#define _GB2_BIOSTRUCT3D_OBJECT_TESTS_H_

#include "XMLTestUtils.h"
#include <QtXml/QDomElement>
#include <QtCore/QHash>

namespace GB2 {

	class Document;
	
    class GTest_BioStruct3DNumberOfAtoms : public GTest {
		Q_OBJECT
			SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_BioStruct3DNumberOfAtoms, "check-biostruct3d-number-of-atoms");

		ReportResult report();

		QString		objContextName;
		int numAtoms;

	};

	class GTest_BioStruct3DNumberOfChains : public GTest {
		Q_OBJECT
			SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_BioStruct3DNumberOfChains, "check-biostruct3d-number-of-chains");

		ReportResult report();

		QString		objContextName;
		int numChains;

	};

	class GTest_BioStruct3DNumberOfResidues : public GTest {
		Q_OBJECT
			SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_BioStruct3DNumberOfResidues, "check-biostruct3d-number-of-residues");

		ReportResult report();

		QString		objContextName;
		int numResidues;

	};

	class GTest_BioStruct3DAtomCoordinates : public GTest {
		Q_OBJECT
			SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_BioStruct3DAtomCoordinates, "check-biostruct3d-atom-coords");

		ReportResult report();

		QString	objContextName;
		double x,y,z;
		int atomId;

	};

	class GTest_BioStruct3DAtomSequenceId : public GTest {
		Q_OBJECT
			SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_BioStruct3DAtomSequenceId, "check-biostruct3d-atom-seqindex");

		ReportResult report();

		QString	objContextName;
		int seqId;
		int atomId;

	};

    class GTest_PDBFormatStressTest : public GTest {
        Q_OBJECT
            SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_PDBFormatStressTest, "try-load-all-pdb-documents");

        ReportResult report();
        QList<Task*> onSubTaskFinished(Task* subTask);
        QHash<Task* , QString>	fileNames;
    };


	class BioStruct3DObjectTests {
	public:
		static QList<XMLTestFactory*> createTestFactories();
	};

}//namespace

#endif //_GB2_BIOSTRUCT3D_OBJECT_TESTS_H_
