/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TASK_TESTS_H_
#define _GB2_TASK_TESTS_H_

#include "XMLTestUtils.h"
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include "DocumentModelTests.h"
namespace GB2 {

class StateOrderTestTask;

class InfiniteTestTask : public Task {
    Q_OBJECT
public:
    InfiniteTestTask(QString _taskName, TaskFlags _f) : Task(_taskName, _f) {}
    void run();
};

class StateOrderTestTaskCallback {
public:
    virtual void func(StateOrderTestTask *t) = 0;
    virtual ~StateOrderTestTaskCallback() {}
};

class StateOrderTestTask : public Task {
    Q_OBJECT
public:
    StateOrderTestTask(StateOrderTestTaskCallback *ptr, TaskFlags _f);
    void prepare();
    void run();
    Task::ReportResult report();
    int step;
private:
    StateOrderTestTaskCallback *callback;
};

class GTest_TaskCreateTest : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskCreateTest, "task-create");

    ReportResult report();
    void cleanup();
private:
    Task *task;
    bool deleteTask;
    QString resultContextName;
};

class GTest_TaskAddSubtaskTest : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskAddSubtaskTest, "task-add-subtask");

    ReportResult report();
private:
    QString taskContextName;
    QString subtaskContextName;
};

class GTest_TaskCancelTest : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskCancelTest, "task-cancel");

    ReportResult report();
private:
    QString objContextName;
};

class GTest_TaskCheckFlag : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskCheckFlag, "task-check-flag");

    ReportResult report();
private:
    TaskFlags flag;
    QString taskContextName;
};

class GTest_TaskCheckState : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskCheckState, "task-check-state");

    ReportResult report();
private:
    bool checkState;
    State taskState;
    bool checkProgress;
    bool checkCancelFlag;
    bool checkError;
    bool checkStateDesc;
    TaskStateInfo taskStateInfo;
    QString taskContextName;
};

class GTest_TaskExec : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskExec, "task-exec");

    void prepare();
    ReportResult report();
private:
    QString taskContextName;
};

class GTest_TaskStateOrder : public GTest, public StateOrderTestTaskCallback{
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_TaskStateOrder, "task-state-order-test");
    void func(StateOrderTestTask *t);
    Task::ReportResult report();
private:
    StateOrderTestTask *task;
    QList<StateOrderTestTask*> subs;
    int subtask_num;
    bool serial_flag;
    bool cancel_flag;
    bool run_after_all_subs_flag;
};

class GTest_Wait : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_Wait, "wait");
    Task::ReportResult report();
private:
    int ms;
};

class TaskTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

}//namespace
#endif
