/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FIND_ALG_TASK_H_
#define _GB2_FIND_ALG_TASK_H_

#include <core_api/Task.h>
#include <core_api/LRegion.h>

#include "FindAlgorithm.h"

#include <QtCore/QMutex>

namespace GB2 {

class DNATranslation;

class GB2_COREAPI_EXPORT FindAlgorithmTaskSettings : public FindAlgorithmSettings {
public:
    FindAlgorithmTaskSettings() {}
    FindAlgorithmTaskSettings(const FindAlgorithmSettings& f) : FindAlgorithmSettings(f) {}
    QByteArray          sequence;
};

class GB2_COREAPI_EXPORT FindAlgorithmTask : public Task, public FindAlgorithmResultsListener {
    Q_OBJECT
public:
    FindAlgorithmTask(const FindAlgorithmTaskSettings& s);

    virtual void run();
    virtual void onResult(const FindAlgorithmResult& r);
    
    int getCurrentPos() const {return currentPos;}

    QList<FindAlgorithmResult> popResults();

    const FindAlgorithmTaskSettings& getSettings() const {return config;}

private:
    FindAlgorithmTaskSettings config;
    
    int     currentPos;
    bool    complementRun;

    QList<FindAlgorithmResult> newResults;
    QMutex lock;
};

} //namespace

#endif
