/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreateAnnotationDialog.h"
#include "CreateAnnotationWidgetController.h"

#include <core_api/AppContext.h>
#include <core_api/DocumentFormats.h>
#include <core_api/IOAdapter.h>
#include <core_api/ProjectModel.h>
#include <gobjects/GObjectRelationRoles.h>


#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QMessageBox>

namespace GB2 {

CreateAnnotationDialog::CreateAnnotationDialog(CreateAnnotationModel* m) {
    c = new CreateAnnotationWidgetController(m, this);
    
    QHBoxLayout* hl = new QHBoxLayout();
    hl->addStretch(1);
    hl->addWidget(createButton = new QPushButton(tr("create_button"), this));
    hl->addWidget(cancelButton = new QPushButton(tr("cancel_button"), this));

    QVBoxLayout* vl = new QVBoxLayout();
//    vl->addWidget(new QLabel("header", this));
    vl->addWidget(c->getWidget());
    vl->addLayout(hl);
    vl->setSizeConstraint(QLayout::SetFixedSize);
    setLayout(vl);

    connect(createButton, SIGNAL(clicked(bool)), SLOT(sl_onCreateClicked(bool)));
    connect(cancelButton, SIGNAL(clicked(bool)), SLOT(sl_onCancelClicked(bool)));

    c->annotationNameEdit->setFocus();
    setWindowTitle(tr("Create annotation"));
}


void CreateAnnotationDialog::sl_onCreateClicked(bool) {
    QString err = c->validate();
    if (!err.isEmpty()) {
        QMessageBox::warning(this, tr("invalid_state_info"), err);
        return;
    } 
    c->prepareAnnotationObject();
    accept();
}

void CreateAnnotationDialog::sl_onCancelClicked(bool) {
    reject();
}



} // namespace
