/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DIALOG_UTILS_H_
#define _GB2_DIALOG_UTILS_H_

#include <core_api/core_api.h>

#include <QtCore/QObject>
#include <QtGui/QWidget>

namespace GB2 {

class DocumentFormatConstraints;

class GB2_COREAPI_EXPORT DialogUtils : public QObject {
	Q_OBJECT
public:
	static void showProjectIsLockedWarning(QWidget* p = NULL);

    static QString prepareFileFilter(const QString& name, const QStringList& exts, bool any = true, const QStringList& extraExts = QStringList(".gz"));

    static QString prepareDocumentsFileFilter(const DocumentFormatId& fid, bool any, const QStringList& extraExts = QStringList(".gz"));

    //returns filter for all formats supported. All-docs filter is returned first if any==true
    static QString prepareDocumentsFileFilter(bool any, const QStringList& extraExts = QStringList(".gz"));

    static QString prepareDocumentsFileFilter(const DocumentFormatConstraints& c, bool any);

    static QString prepareDocumentsFileFilterByObjType(const GObjectType& t, bool any);


    static QString getLastOpenFileDir(const QString& toolType = QString(), const QString& defaultVal = QString());

    static void setLastOpenFileDir(const QString& ld, const QString& toolType = QString());



    //gets the extension of the document. Filters 'gz' like suffixes
    static QString getDocumentExtension(const QString& url);

    // adds baseSuffix to the url. Ensures that URL ends with one of the exts from typeExt
    static QString prepareFileName(const QString& url, const QString& baseSuffix, QStringList typeExt);

    // adds count to the url. Ensures that URL ends with one of the exts from typeExt
    static QString prepareFileName(const QString& url, int count, QStringList typeExt);

    //ensures that url ends with one of the exts
    static QString ensureFileExt(const QString& url, QStringList typeExt);
};

class GB2_COREAPI_EXPORT LastOpenDirHelper {
public:
    LastOpenDirHelper(const QString& domain = QString(), const QString& defaultVal = QString()); //reads dir
    virtual ~LastOpenDirHelper(); //if url is not empty -> derives dir from url and stores it
    
    operator const QString&() const {return dir;} 
    void saveURLDir2LastOpenDir();

    QString domain;

    //last used dir
    QString dir;

    // value returned by file dialog
    QString url;
};
} // namespace

#endif
