/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GOBJECT_COMBOBOX_CONTROLLER_H_
#define _GB2_GOBJECT_COMBOBOX_CONTROLLER_H_

#include <core_api/DocumentModel.h>
#include <core_api/GObjectReference.h>

#include <QtGui/QComboBox>

namespace GB2 {
    
class GObjectComboBoxControllerConstraints {
public:
    GObjectComboBoxControllerConstraints() {
        onlyWritable = false;
    }

    GObjectType             typeFilter;
    GObjectRelation         relationFilter;
    bool                    onlyWritable;
};

class GB2_COREAPI_EXPORT GObjectComboBoxController : public QObject {
    Q_OBJECT
public:
    GObjectComboBoxController(QObject* p, const GObjectComboBoxControllerConstraints& c, QComboBox* combo);

    bool setSelectedObject(GObject* obj);

    GObject* getSelectedObject() const;

private slots:
    void sl_onDocumentAdded(Document* d);
    void sl_onDocumentRemoved(Document* d);
    void sl_onObjectAdded(GObject* o);
    void sl_onObjectRemoved(GObject* o);
    void sl_lockedStateChanged();

private:
    void updateCombo();
    void addObject(GObject*);
    void removeObject(GObject*);
    void addDocumentObjects(Document* d);
    void removeDocumentObjects(Document* d);

    GObjectComboBoxControllerConstraints settings;
    QComboBox*          combo;
    QList<GObject*>     comboMapper;
    QIcon               objectIcon;
};

}//namespace

#endif
