/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GUI_UTILS_H_
#define _GB2_GUI_UTILS_H_

#include <core_api/core_api.h>

#include <QtGui/QAction>
#include <QtGui/QMenu>
#include <QtCore/QList>

namespace GB2 {

class GB2_COREAPI_EXPORT GUIUtils : public QObject {
    Q_OBJECT
public:
    
    static QAction* findAction(const QList<QAction*>& actions, const QString& name);
    
    static QAction* findActionAfter(const QList<QAction*>& actions, const QString& name);

    static QMenu* findSubMenu(QMenu* m, const QString& name);

    static void disableEmptySubmenus(QMenu* m);

    static QColor genLightColor(const QString& name);

    static QIcon  createSquareIcon(const QColor& c, int size);

    static bool runWebBrowser(const QString& url);
};

class GB2_COREAPI_EXPORT Translations : public QObject {
    Q_OBJECT
public:

    static QString errorOpeningFileRead(const QString& url) { return tr("Cannot open file to read: '%1'").arg(url);}
    static QString errorOpeningFileWrite(const QString& url) { return tr("Cannot open file to write: '%1'").arg(url);}
    static QString errorWritingFile(const QString& url) { return tr("Error writing to file: '%1'").arg(url);}
    static QString errorFileTooLarge(const QString& url) { return tr("File is too large: '%1'").arg(url);}
};

} //namespace

#endif
