/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_POSITION_SELECTOR_H_
#define _GB2_POSITION_SELECTOR_H_

#include <core_api/core_api.h>

#include <QtGui/QLineEdit>
#include <QtGui/QValidator>
#include <QtGui/QDialog>

namespace GB2 {

class GB2_COREAPI_EXPORT PositionSelector : public QWidget {
	Q_OBJECT
public:
	PositionSelector(QWidget* p, int rangeStart, int rangeEnd);
    PositionSelector(QDialog* d, int rangeStart, int rangeEnd, bool autoclose);

	~PositionSelector();
    
    QLineEdit* getPosEdit() const {return posEdit;}

signals:
	void si_positionChanged(int pos);

private slots:
	void sl_onButtonClicked(bool);
	void sl_onReturnPressed();

private:
    void init();
	void exec();

	int rangeStart;
	int rangeEnd;
	QLineEdit* posEdit;
    bool autoclose;
    QDialog* dialog;
};

}//namespace

#endif
