/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SAVE_DOCUMENT_TASK_H_
#define _GB2_SAVE_DOCUMENT_TASK_H_

#include <core_api/Task.h>

#include <QtCore/QPointer>

namespace GB2 {

class Document;
class StateLock;
class IOAdapterFactory;

class GB2_COREAPI_EXPORT SaveDocumentTask : public Task {
    Q_OBJECT
public:
	SaveDocumentTask(Document* doc, IOAdapterFactory* io = NULL, const QString& url = QString::null);
    SaveDocumentTask(Document* doc, bool destroy);
    ~SaveDocumentTask();

	virtual void prepare();

	virtual void run();

	ReportResult report();

private:
	StateLock* lock;
	Document* doc;
	IOAdapterFactory* io;
	QString url;
    bool destroy;
};


class GB2_COREAPI_EXPORT SaveMiltipleDocuments: public Task {
    Q_OBJECT
public:

	SaveMiltipleDocuments(const QList<Document*>& docs, bool askBeforeSave);

	static QList<Document*> findModifiedDocuments(const QList<Document*>& docs);
};

enum UnloadDocumentTask_SaveMode {
    UnloadDocumentTask_SaveMode_Ask,
    UnloadDocumentTask_SaveMode_NotSave,
    UnloadDocumentTask_SaveMode_Save
};


class GB2_COREAPI_EXPORT UnloadDocumentTask: public Task {
    Q_OBJECT
public:
    UnloadDocumentTask(Document* doc, bool save);
    ReportResult report();

    static void runUnloadTaskHelper(const QList<Document*>& docs, UnloadDocumentTask_SaveMode sm);
    static QString checkSafeUnload(Document* d);

private:
    QPointer<Document>      doc;
    SaveDocumentTask*       saveTask;
};

}//namespace

#endif
