/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SequenceWalkerTests.h"
#include "../SequenceWalkerTask.h"

#include <core_api/LRegion.h>
#include <core_api/GObject.h>
#include <gobjects/GObjectTypes.h>

/* TRANSLATOR GB2::GTest */

namespace GB2 {
//chunksize="110" overlapsize="51" regionrange="158" normk="1" revertNorm="no"
#define CHUNK_SIZE_ATTR "chunksize"
#define OVERLAP_SIZE_ATTR "overlapsize"
#define EXTRA_OVERLAP_SIZE_ATTR "exoverlapsize"
#define REGION_SIZE_ATTR "regionsize"
#define NORMK_ATTR "normk"
#define REVENT_NORM_ATTR "revertNorm"
#define REGION_ATTR "region"

void GTest_SW_CheckRegion::init(XMLTestFormat *tf, const QDomElement& el) {
    Q_UNUSED(tf);

    
	QString chunkSize_str = el.attribute(CHUNK_SIZE_ATTR);
	if (chunkSize_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(CHUNK_SIZE_ATTR);
		return;
	}
	bool ok=false;
	chunkSize = chunkSize_str.toInt(&ok);
	if(!ok) {
		stateInfo.error = GTest::tr("value not set %1").arg(CHUNK_SIZE_ATTR);
		return;
	}
	QString overlapSize_str = el.attribute(OVERLAP_SIZE_ATTR);
	if (overlapSize_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(OVERLAP_SIZE_ATTR);
		return;
	}
	ok=false;
	overlapSize = overlapSize_str.toInt(&ok);
	if(!ok) {
		stateInfo.error = GTest::tr("value not set %1").arg(OVERLAP_SIZE_ATTR);
		return;
	}
	QString exOverlapSize_str = el.attribute(EXTRA_OVERLAP_SIZE_ATTR);
	if (exOverlapSize_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(EXTRA_OVERLAP_SIZE_ATTR);
		return;
	}
	ok=false;
	exOverlapSize = exOverlapSize_str.toInt(&ok);
	if(!ok) {
		stateInfo.error = GTest::tr("value not set %1").arg(EXTRA_OVERLAP_SIZE_ATTR);
		return;
	}
	QString regionSize_str = el.attribute(REGION_SIZE_ATTR);
	if (regionSize_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(REGION_SIZE_ATTR);
		return;
	}
	ok=false;
	regionSize = regionSize_str.toInt(&ok);
	if(!ok) {
		stateInfo.error = GTest::tr("value not set %1").arg(REGION_SIZE_ATTR);
		return;
	}
	QString normK_str = el.attribute(NORMK_ATTR);
	if (normK_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(NORMK_ATTR);
		return;
	}
	ok=false;
	normK = normK_str.toInt(&ok);
	if(!ok) {
		stateInfo.error = GTest::tr("value not set %1").arg(NORMK_ATTR);
		return;
	}
	QString reventNorm_str = el.attribute(REVENT_NORM_ATTR);
	if (reventNorm_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(REVENT_NORM_ATTR);
		return;
	}
	if(reventNorm_str == "true")
		reventNorm = true;
	else if(reventNorm_str == "false")
		reventNorm = false;
	else {
		stateInfo.error = GTest::tr("value not set %1").arg(REVENT_NORM_ATTR);
		return;
	}
	QString regions_str = el.attribute(REGION_ATTR);
	if (regions_str.isEmpty()) {
		stateInfo.error = GTest::tr("value not set %1").arg(REGION_ATTR);
		return;
	}
	QRegExp rx("(\\d+)(..)(\\d+)");
    QStringList list;
    int pos = 0;
    while ((pos = rx.indexIn(regions_str, pos)) != -1) {
        int start=rx.cap(1).toInt();
        int end=rx.cap(3).toInt();
        regions.append(LRegion(start,end-start));
        pos += rx.matchedLength();
    }
}
Task::ReportResult GTest_SW_CheckRegion::report() {
	
	QList<LRegion> chunks = SequenceWalkerTask::splitRange(LRegion(0,regionSize), qMin(chunkSize, regionSize), overlapSize, exOverlapSize, normK, reventNorm);
	int n = regions.size();
    if (n!=chunks.size()) {
        stateInfo.error = GTest::tr("number of regions not matched: %1, expected %2").arg(chunks.size()).arg(n);
        return ReportResult_Finished;
    }
    for(int i=0; i<n; i++) {
        const LRegion& region = regions[i];
        const LRegion& chunk = chunks[i];
        if (chunk!=region) {
			stateInfo.error = GTest::tr("location not matched, idx=%1, \"%2..%3\", expected \"%4..%5\"").arg(i).arg(chunk.startPos).arg(chunk.endPos()).arg(region.startPos).arg(region.endPos());
            return ReportResult_Finished;
        }
    }
	
	return ReportResult_Finished;
}

QList<XMLTestFactory*> SequenceWalkerTests::createTestFactories() {
    QList<XMLTestFactory*> res;
    res.append(GTest_SW_CheckRegion::createFactory());
    return res;
}

}//namespace
