/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIO_DATATYPE_H_
#define _GB2_BIO_DATATYPE_H_

#include <workflow/Datatype.h>

namespace GB2 {

class WCOREAPI_EXPORT BioDataTypes : public QObject {
public:
    static const QString DNA_SEQUENCE_TYPE_ID;
    static const QString ANNOTATION_TYPE_ID;
    static const QString ANNOTATION_TABLE_LIST_TYPE_ID;
    static const QString ANNOTATION_TABLE_TYPE_ID;
    static const QString DNA_CHROMATOGRAM_TYPE_ID;
    static const QString MULTIPLE_ALIGNMENT_TYPE_ID;

    static DataTypePtr DNA_SEQUENCE_TYPE();
    static DataTypePtr ANNOTATION_TYPE();
    static DataTypePtr ANNOTATION_TABLE_LIST_TYPE();
    static DataTypePtr ANNOTATION_TABLE_TYPE();

    static DataTypePtr DNA_CHROMATOGRAM_TYPE();
    static DataTypePtr MULTIPLE_ALIGNMENT_TYPE();
};

} //namespace
#endif
