/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_OPENGL_WIDGET_H_
#define _GB2_OPENGL_WIDGET_H_

#include <QtOpenGL/QGLWidget>
#include <QtGui/QMenu>
#include <QtGui/QActionGroup>
#include <QtGui/QAction>
#include <QtGui/QColor>
#include <QtCore/QTimer>
#include <QMetaType>

#include <core_api/Vector3D.h>
#include <core_api/LRegion.h>
#include <memory>

namespace GB2 { 

#define ULOG_CAT_PLUGIN_BIOSTRUCT_3D "Plugin: BioStruct 3D View"

class Document;
class BioStruct3D;
class BioStruct3DGLRenderer;
class BioStruct3DColorScheme;
class BioStruct3DColorSchemeFactory;
class BioStruct3DGLRendererFactory;
class AnnotatedDNAView;
class Annotation;
class AnnotationTableObject;
class AnnotationSelection;
class ADVSequenceObjectContext;
class LRegionsSelection;


class Matrix4x4 {
public:
	
    float m[16];

	Matrix4x4();
	void loadIdentity();
    float* getData() { return m; }
	float& operator [] (unsigned int i);
    Matrix4x4& operator= (const Matrix4x4& m);
    void load(QVariantList values);
    QVariantList store();

};


class BioStruct3DGLWidget : public QGLWidget
{
    Q_OBJECT
	static const int GL_MATRIX_SIZE = 16;
	static const float DEFAULT_ZOOM;
    static int widgetCount;

public:
    BioStruct3DGLWidget(const BioStruct3D& struc, const Document* doc, const AnnotatedDNAView* view,  QWidget *parent);
    ~BioStruct3DGLWidget();
    QMap<QString, QColor> getSecStructAnnotationColors() const;
    const QMap<int, QColor> getChainColors() const;
    const QList<ADVSequenceObjectContext*> getSequenceContexts() const;
    const BioStruct3D& getBioStruct3D() const { return biostruc; }
    const QString getBioStruct3DObjectName() const;
    QMenu* getDisplayMenu();
    QVariantMap getState();
    void setState(const QVariantMap& state);
    void restoreDefaultSettigns();
    void zoom(float delta);
    
signals:
    void si_widgetClosed(BioStruct3DGLWidget* w);

protected:
    void initializeGL();
    void resizeGL(int width, int height);
    void paintGL();
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent ( QWheelEvent * event );
	void contextMenuEvent(QContextMenuEvent *_event);

private slots:
	void sl_selectColorScheme(QAction* action);
    void sl_selectGLRenderer(QAction* action);
	void sl_updateRenderSettings(const QStringList& list);
    void sl_acitvateSpin();
    void sl_onSequenceSelectionChanged(LRegionsSelection* s, const QList<LRegion>& r, const QList<LRegion>& a);
    void sl_onAnnotationSelectionChanged(AnnotationSelection* thiz, const QList<Annotation*>& added, const QList<Annotation*>& removed);
    void sl_updateAnnimation();
    void sl_setBackgroundColor();
    void sl_closeWidget();
    void sl_exportImage();

private:
    void setZoomFactor(float factor) { zoomFactor = factor; }
    void setBioStruct3DColorScheme(BioStruct3DColorScheme* clScheme);
    void setBioStruct3DRenderer(BioStruct3DGLRenderer* renderer);
    void setLightPosition(const Vector3D& pos);
    void createActions();
    void createMenus();
    void saveDefaultsSettings();
    BioStruct3DColorScheme* createCustomColorScheme(const QString& name); 
    BioStruct3DGLRenderer* createCustomRenderer(const QString& name);
    int getChainIdFromAnnotationObject(const AnnotationTableObject* ao); 
    static QString getQualifierValueByName(const Annotation* annotation, const QString& qualifierName);
    static int getWidgetCount(QString objectName);
    void connectExternalSignals();
    void draw();
    Vector3D getTrackballMapping(int x, int y);
	
    const BioStruct3D& biostruc;
    const Document* biostrucDoc;
    const AnnotatedDNAView* dnaView;
    QVariantMap defaultsSettings;
    QString currentColorSchemeName;
    QString currentGLRendererName;
    QString currentModelID;
    std::auto_ptr<BioStruct3DColorScheme> colorScheme;
    std::auto_ptr<BioStruct3DGLRenderer> renderer;
    QMap<QString, BioStruct3DColorSchemeFactory*> colorSchemeFactoryMap;
    QMap<QString, BioStruct3DGLRendererFactory*> rendererFactoryMap;
    QMap<const AnnotationTableObject*, int> chainIdCache;
    GLfloat cameraDistance, cameraClipNear, cameraClipFar;
    GLfloat zoomFactor;
    GLfloat rotAngle, spinAngle;
    GLfloat lightPostion[4];
    Matrix4x4 rotMatrix;
    Vector3D rotAxis, lastPos, yAxis;
    QAction *spinAction;
    QAction *setBackgroundColorAction;
    QAction *closeAction;
    QAction *exportImageAction;
    QActionGroup *colorSchemeActions;
    QActionGroup *rendererActions;
    QTimer* animationTimer;
    QMenu *selectColorSchemeMenu;
    QMenu *selectRendererMenu;
    QMenu *displayMenu;
    QColor backgroundColor;

};

} //namespace


#endif // _GB2_OPENGL_WIDGET_H
