/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MWTOOLBAR_IMPL_H_
#define _GB2_MWTOOLBAR_IMPL_H_

#include <core_api/MainWindow.h>

#include <QtGui/QToolBar>
#include <QtGui/QMainWindow>

namespace GB2 {

class MWToolBarManagerImpl : public MWToolBarManager {
public:	
	MWToolBarManagerImpl(QMainWindow* mw);
	~MWToolBarManagerImpl();

	virtual QToolBar* getToolbar(const QString& sysName) const;

protected:
	bool eventFilter(QObject *obj, QEvent *event);

private:
	QToolBar* createToolBar(const QString& sysName);
	void updateToolbarVisibilty();

	QMainWindow*		mw;
	QList<QToolBar*>	toolbars;
};

}//namespace

#endif
