/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __CUDA_GPU_REGISTRY_H__
#define __CUDA_GPU_REGISTRY_H__

#include <QtCore/QHash>
#include "core_api.h"

namespace GB2 {

typedef int CudaGpuId;

const static char * CUDA_GPU_REGISTRY_SETTINGS = "/cuda_gpu_registry";
//stores settings for concrete GPU. The key for appending - textual representation of CudaGpuId
const static char * CUDA_GPU_REGISTRY_SETTINGS_GPU_SPECIFIC = "/cuda_gpu_registry/gpu_specific";
const static char * CUDA_GPU_SETTINGS_ENABLED = "/enabled";

class GB2_COREAPI_EXPORT CudaGpuModel {
public:
    CudaGpuModel( const QString & _name, const CudaGpuId & _id, int _globalMemorySize, bool _enabled  = true) :
      name(_name), id(_id), globalMemorySize(_globalMemorySize), enabled(_enabled) {};

    QString getName() const {return name;}
    CudaGpuId getId() const {return id;}
    int getGlobalMemorySize() const {return globalMemorySize;}
    bool isEnabled() const { return enabled;}

    void setEnabled(bool b) {enabled = b;}
private:
    //TODO: add another cuda device properties from cudaDeviceProp
    QString name;
    CudaGpuId id;
    int globalMemorySize;
    bool enabled;
};

class GB2_COREAPI_EXPORT CudaGpuRegistry {
public:
    ~CudaGpuRegistry();

    void registerCudaGpu( CudaGpuModel * gpu );
    CudaGpuModel * getGpuById( CudaGpuId id ) const;
    QList<CudaGpuModel*> getRegisteredGpus() const;

    CudaGpuModel * getAnyEnabledGpu() const;

    bool empty() const { return gpus.empty(); }

private:
    void saveGpusSettings() const;
    QHash< CudaGpuId, CudaGpuModel * > gpus;  
};

} //namespace

#endif //__CUDA_GPU_REGISTRY_H__
