/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MAIN_WINDOW_H_
#define _GB2_MAIN_WINDOW_H_

#include "core_api.h"
#include "PluginModel.h"
#include "ServiceTypes.h"
#include <QtGui/QWidget>
#include <QtScript>

class QAction;
class QMdiSubWindow;
class QDockWidget;
class QMenu;
class QToolBar;
class QMainWindow;

namespace GB2 {


class MWMenuManager;
class MWMenu;
class MWMenuItem;
class MWToolBarManager;
class MWToolBar;
class MWMDIManager;
class MWDockManager;

class GB2_COREAPI_EXPORT MainWindow : public QObject {
    Q_OBJECT
public:
	Q_INVOKABLE virtual MWMenuManager*          getMenuManager() const = 0;
    Q_INVOKABLE virtual MWToolBarManager*       getToolBarManager() const = 0;
    Q_INVOKABLE virtual MWMDIManager*           getMDIManager() const = 0;
    Q_INVOKABLE virtual MWDockManager*          getDockManager() const = 0;
    
	Q_INVOKABLE virtual void setWindowTitle(const QString& title) = 0;
    Q_INVOKABLE virtual QMainWindow* getQMainWindow() const = 0;

    static void setupToEngine(QScriptEngine *engine);
private:
    static QScriptValue toScriptValue(QScriptEngine *engine, MainWindow* const &in);
    static void fromScriptValue(const QScriptValue &object, MainWindow* &out);

};

//////////////////////////////////////////////////////////////////////////
/// MENU


class GB2_COREAPI_EXPORT MWMenuManager : public QObject {
    Q_OBJECT
public:
    MWMenuManager(QObject* p) : QObject(p){}

    Q_INVOKABLE virtual QMenu* getTopLevelMenu(const QString& sysName) const = 0;

    static void setupToEngine(QScriptEngine *engine);
private:
    static QScriptValue toScriptValue(QScriptEngine *engine, MWMenuManager* const &in);
    static void fromScriptValue(const QScriptValue &object, MWMenuManager* &out);

};

//////////////////////////////////////////////////////////////////////////
/// Toolbar

class GB2_COREAPI_EXPORT  MWToolBarManager : public QObject {
    Q_OBJECT
public:
    MWToolBarManager(QObject* p) : QObject(p){}

	virtual QToolBar* getToolbar(const QString& sysName) const  = 0;
};

//////////////////////////////////////////////////////////////////////////
/// MDI

class GB2_COREAPI_EXPORT MWMDIWindow : public QWidget {
    Q_OBJECT

    friend class MWMDIManager;
public:
	
	MWMDIWindow(const QString& _windowName);

	const QString& getWindowName() const {return windowName;}

	//BUG:416: conflict with ObjectViewName!!!
	virtual void setWindowName(const QString& newWindowName) {
		if (newWindowName != windowName) {
			windowName = newWindowName;
            setWindowTitle(windowName);
			emit si_windowNameChanged(this);
		}
	}

	virtual void setupMDIToolbar(QToolBar* tb) {Q_UNUSED(tb);}
	virtual void setupViewMenu(QMenu* m) {Q_UNUSED(m);}

    int getId() const {return windowId;}

protected:
    /* returns true if a window may be closed, false otherwise */
    virtual bool onCloseEvent() {return true;}

signals:
	void si_windowNameChanged(MWMDIWindow* thiz);

protected:
	QString windowName;
    int     windowId;
};

class GB2_COREAPI_EXPORT MWMDIManager : public QObject {
    Q_OBJECT
public:
    MWMDIManager(QObject* p) : QObject(p){}
    
	virtual void addMDIWindow(MWMDIWindow* w) = 0;
	
	virtual bool closeMDIWindow(MWMDIWindow* w) = 0;

	virtual QList<MWMDIWindow*> getWindows() const = 0;

	virtual MWMDIWindow* getWindowById(int id) const = 0;

	virtual Qt::WindowStates getWindowState(MWMDIWindow* w) const = 0;

	virtual void activateWindow(MWMDIWindow* w) = 0;

	virtual MWMDIWindow* getActiveWindow() const = 0;

    virtual MWMDIWindow* addTextWindow(const QString& title, const QString& textOrHtml) = 0;

signals:
	void si_windowAdded(MWMDIWindow* w);
    void si_windowClosing(MWMDIWindow* w);

protected: 
    /* returns true if the window agreed to close, false otherwise */
    bool onCloseEvent(MWMDIWindow* w) {return w->onCloseEvent();}
};

//////////////////////////////////////////////////////////////////////////
/// DOCK

enum MWDockArea {
    MWDockArea_Left,
    MWDockArea_Right,
    MWDockArea_Bottom,
    MWDockArea_MaxDocks
};

class GB2_COREAPI_EXPORT MWDockManager: public QObject {
    Q_OBJECT
public:
    MWDockManager(QObject* p) : QObject(p){}
    
	virtual QAction* registerDock(MWDockArea area, QWidget* w, const QKeySequence& ks = QKeySequence()) = 0;

    virtual QWidget* findWidget(const QString& widgetObjName) = 0;

    virtual QWidget* getActiveWidget(MWDockArea a) = 0;

    virtual QWidget* activateDock(const QString& widgetObjName) = 0;

    virtual QWidget* toggleDock(const QString& widgetObjName) = 0;
};

}//namespace
Q_DECLARE_METATYPE(GB2::MainWindow*)
Q_DECLARE_METATYPE(GB2::MWMenuManager*)
Q_DECLARE_METATYPE(GB2::MWToolBarManager*)
Q_DECLARE_METATYPE(GB2::MWMDIManager*)
Q_DECLARE_METATYPE(GB2::MWDockManager*)
#endif
