/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_CONSENSUS_AREA_H_
#define _GB2_MSA_EDITOR_CONSENSUS_AREA_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtGui/QWidget>
#include <QtGui/QMenu>
#include <QtGui/QHelpEvent>

namespace GB2 {

class MSAEditor;
class MSAEditorUI;
class GObjectView;
class MSAEditorConsensusCache;
class MAlignment;
class MAlignmentModInfo;

enum MSAEditorConsElement {
    MSAEditorConsElement_HISTOGRAM,
    MSAEditorConsElement_CONSENSUS_TEXT,
    MSAEditorConsElement_RULER
};

class GB2_COREAPI_EXPORT MSAEditorConsensusArea : public QWidget {
    Q_OBJECT
public:
    MSAEditorConsensusArea(MSAEditorUI* ui);
    ~MSAEditorConsensusArea();

    LRegion getRullerLineYRange() const;

protected:
    virtual bool event(QEvent* e);
    void paintEvent(QPaintEvent*);
    void resizeEvent(QResizeEvent*);

private slots:
    void sl_startChanged(const QPoint&, const QPoint&);
    void sl_cursorMoved(const QPoint& pos, const QPoint& prev);
    void sl_alignmentChanged(const MAlignment&, const MAlignmentModInfo&);
    
    void sl_buildStaticMenu(GObjectView* v, QMenu* m);
    void sl_buildContextMenu(GObjectView* v, QMenu* m);
    void sl_copyConsensusSequence();
    void sl_scaleChanged();

private:
    QString createToolTip(QHelpEvent* he) const;
    void buildMenu(QMenu* m);
    void setupFontAndHeight();

    void drawConsensus(QPainter& p);
    void drawConsensusChar(QPainter& p, int pos, bool selected);
    void drawCursor(QPainter& p);
    void drawRuler(QPainter& p);
    void drawHistogram(QPainter& p);

    LRegion getYRange(MSAEditorConsElement e) const;

    MSAEditor*          editor;
    const MSAEditorUI*  ui;
    QFont               rulerFont;
    int                 rulerFontHeight;
    QAction*            copyConsensusAction;

    MSAEditorConsensusCache*    consensusCache;
    
    bool                completeRedraw;
    QPixmap*            cachedView;
};


}//namespace
#endif

