/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEC_STRUCT_PREDICT_TESTS_H_
#define _GB2_SEC_STRUCT_PREDICT_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>


namespace GB2 {

class SecStructPredictTask;
class AnnotationTableObject;


class GTest_SecStructPredictAlgorithm : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_SecStructPredictAlgorithm, "test-sec-struct-predict-algorithm");
    void prepare();
    Task::ReportResult report();
private:
    SecStructPredictTask* task;
    QString algName;
    QString inputSeq;
    QString outputSeq;
};


class GTest_SecStructPredictTask : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_SecStructPredictTask, "predict-sec-structure-and-save-results");
    void prepare();
    void cleanup();
    Task::ReportResult report();
private:
    bool contextAdded;
    SecStructPredictTask* task;
    AnnotationTableObject* aObj;
    QString seqName;
    QString algName;
    QString resultsTableContextName;
};


class GB2_COREAPI_EXPORT SecStructPredictTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};




} //namespace
#endif

