/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SUBST_MATRIX_DIALOG_H_
#define _GB2_SUBST_MATRIX_DIALOG_H_

#include "ui_SubstMatrixDialogBase.h"

#include <QDialog>
#include <core_api/core_api.h>
#include <util_smith_waterman/SubstMatrix.h>

namespace GB2 {

class GB2_COREAPI_EXPORT SubstMatrixDialog: public QDialog, public Ui::SubstMatrixDialogBase {
	Q_OBJECT
public:
	SubstMatrixDialog(const SubstMatrix* pSm, const QString& mtx_name);
private slots:
	void sl_newMatrix();
	void sl_saveMatrix();
	void sl_closeWindow();
	void sl_teAlphabetChanged(QString newStr);

	void sl_mouseOnCell(int row, int column);
	void sl_changedCell(int row, int column);
	
private:
	static const int cell_width = 30;

	static const quint8 hdr_clr_r = 200;
	static const quint8 hdr_clr_g = 200;
	static const quint8 hdr_clr_b = 200;

	static const quint8 hlhdr_clr_r = 150;
	static const quint8 hlhdr_clr_g = 150;
	static const quint8 hlhdr_clr_b = 150;

	float* saveDiagEl;
	int hlRow;
	int hlColumn;

	void connectGUI();
	void hideAll();
	void drawMatrix();

	const SubstMatrix* pSm;	
};

} // namespace

#endif
