/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MolecularSurfaceRenderer.h"
#include <molecular_geometry/MolecularSurface.h>
#include <QtOpenGL>

namespace GB2 {

const QString DotsRenderer::ID(QObject::tr("Dots"));
const QString ConvexMapRenderer::ID(QObject::tr("ConvexMap"));

#define REGISTER_FACTORY(c) \
    map.insert(c::ID, new c::Factory)

QMap<QString,MolecularSurfaceRendererFactory*> MolecularSurfaceRendererFactory::createFactories()
{
    QMap<QString,MolecularSurfaceRendererFactory*> map;
    REGISTER_FACTORY(DotsRenderer);
    REGISTER_FACTORY(ConvexMapRenderer);
    return map;
}

MolecularSurfaceRenderer::MolecularSurfaceRenderer()
{

}

void DotsRenderer::drawSurface( MolecularSurface& surface )
{
    glDisable(GL_LIGHTING);
    glBegin(GL_POINTS);
    glPointSize(1.0f);
    glColor3f(1.0f, 1.0f, 1.0f);
    foreach(const Face& face, surface.getFaces()) {
        glVertex3f(face.v[0].x, face.v[0].y, face.v[0].z);
        glVertex3f(face.v[1].x, face.v[1].y, face.v[1].z);
        glVertex3f(face.v[2].x, face.v[2].y, face.v[2].z);
    }
    glEnd( );
    glEnable(GL_LIGHTING);


}

void ConvexMapRenderer::drawSurface( MolecularSurface& surface )
{
    static GLfloat wall_mat[] = {1.f, 1.f, 1.f, 0.3f};
    glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, wall_mat);

    glBegin(GL_TRIANGLES);
    foreach(const Face& face, surface.getFaces()) {
        glNormal3f(face.n[0].x, face.n[0].y, face.n[0].z);
        glVertex3f(face.v[0].x, face.v[0].y, face.v[0].z);
        glNormal3f(face.n[1].x, face.n[1].y, face.n[1].z);
        glVertex3f(face.v[1].x, face.v[1].y, face.v[1].z);
        glNormal3f(face.n[2].x, face.n[2].y, face.n[2].z);
        glVertex3f(face.v[2].x, face.v[2].y, face.v[2].z);
    }
    glEnd( );
}

} // namespace
