/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "EnzymesPlugin.h"
#include "FindEnzymesDialog.h"
#include "EnzymesTests.h"

#include <core_api/AppContext.h>
#include <core_api/MainWindow.h>
#include <core_api/DNAAlphabet.h>
#include <util_algorithm/GAutoDeleteList.h>

#include <util_gui/GUIUtils.h>
#include <util_gui/DialogUtils.h>

#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>

#include <test_framework/GTestFrameworkComponents.h>

#include <QtCore/QDir>
#include <QtGui/QMenu>

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin * GB2_PLUGIN_INIT_FUNC() {
    EnzymesPlugin * plug = new EnzymesPlugin();
    return plug;
}

EnzymesPlugin::EnzymesPlugin() : Plugin( tr("Restriction analysis"), 
                                        tr("Tools to find and mark restriction enzymes cut sites in DNA sequences") ),
                                        ctxADV(NULL)
{
    if (AppContext::getMainWindow()) {
        ctxADV = new EnzymesADVContext(this);
        ctxADV->init();
    }

    FindEnzymesDialog::initSettings();

    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = EnzymeTests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        assert(res);
        Q_UNUSED(res);
    }

}

EnzymesADVContext::EnzymesADVContext(QObject* p) : GObjectViewWindowContext(p, ANNOTATED_DNA_VIEW_FACTORY_ID)
{
}

void EnzymesADVContext::initViewContext(GObjectView* view) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(view);
    ADVGlobalAction* a = new ADVGlobalAction(av, QIcon(":enzymes/images/enzymes.png"), tr("Restriction sites.."), 50);
    a->addAlphabetFilter(DNAAlphabet_NUCL);
    connect(a, SIGNAL(triggered()), SLOT(sl_search()));
}


void EnzymesADVContext::sl_search() {
    GObjectViewAction* action = qobject_cast<GObjectViewAction*>(sender());
    assert(action!=NULL);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(action->getObjectView());
    assert(av!=NULL);

    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
    assert(seqCtx->getAlphabet()->isNucleic());
    FindEnzymesDialog d(seqCtx);
    d.exec();
}


} //namespace
