/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ENZYMES_DIALOG_H_
#define _GB2_ENZYMES_DIALOG_H_

#include <core_api/MainWindow.h>

#include <ui/ui_FindEnzymesDialog.h>

#include "EnzymeModel.h"

#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>

namespace GB2 {

class ADVSequenceObjectContext;
class CreateAnnotationWidgetController;
class EnzymeGroupTreeItem;

class FindEnzymesDialog : public QDialog, public Ui_FindEnzymesDialog {
    Q_OBJECT
public:
    FindEnzymesDialog(ADVSequenceObjectContext* ctx);
    ~FindEnzymesDialog();

    static void initSettings();
    virtual void accept();

private slots:
    void sl_selectFile();
    void sl_selectAll();
    void sl_selectNone();
    void sl_inverseSelection();
    void sl_openDBPage();
    void sl_itemChanged(QTreeWidgetItem* item, int col);

private:
    void loadFile(const QString& url);
    void setEnzymesList(const QList<SEnzymeData>& enzymes);
    void updateStatus();
    
    EnzymeGroupTreeItem* findGroupItem(const QString& s, bool create);

    static QList<SEnzymeData>   loadedEnzymes;
    static QSet<QString>        lastSelection;

    ADVSequenceObjectContext*           seqCtx;
    CreateAnnotationWidgetController*   ac;
    int                                 totalEnzymes;
    bool                                ignoreItemChecks;
};

class EnzymeTreeItem;
class EnzymeGroupTreeItem : public QTreeWidgetItem {
public:
    EnzymeGroupTreeItem(const QString& s);
    void updateVisual();
    QString s;
    QSet<EnzymeTreeItem*> checkedEnzymes;
    bool operator<(const QTreeWidgetItem & other) const;
};

class EnzymeTreeItem : public QTreeWidgetItem {
public:
    EnzymeTreeItem(const SEnzymeData& ed);
    SEnzymeData enzyme;
    bool operator<(const QTreeWidgetItem & other) const;
};

} //namespace

#endif
