/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SiteconPlugin.h"
#include "SiteconBuildDialogController.h"
#include "SiteconSearchDialogController.h"
#include "SiteconWorkers.h"
#include "SiteconAlgorithmTests.h"
#include "DIPropertiesTests.h"
#include "SiteconIO.h"

#include <core_api/DNAAlphabet.h>
#include <gobjects/DNASequenceObject.h>

#include <util_algorithm/GAutoDeleteList.h>

#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVUtils.h>

#include <util_gui/DialogUtils.h>
#include <util_gui/GUIUtils.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>

#include <core_api/AppContext.h>

namespace GB2 {

DinucleotitePropertyRegistry SiteconPlugin::dp;

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    SiteconPlugin* plug = new SiteconPlugin();
    return plug;
}

    
SiteconPlugin::SiteconPlugin() : Plugin(tr("sitecon_plugin"), tr("sitecon_plugin_desc")), ctxADV(NULL)
{
    if (AppContext::getMainWindow()) {
        ctxADV = new SiteconADVContext(this);
        ctxADV->init();

        QAction* buildAction = new QAction(tr("sitecon_build"), this);
        connect(buildAction, SIGNAL(triggered()), SLOT(sl_build()));

        
        MWMenuManager* menu = AppContext::getMainWindow()->getMenuManager();
        QMenu* tools = menu->getTopLevelMenu(MWMENU_TOOLS);
        QMenu* toolsSubmenu = tools->addMenu(QIcon(":/sitecon/images/sitecon.png"), tr("sitecon_menu"));

        toolsSubmenu->addAction(buildAction);
    }

    LocalWorkflow::SiteconWorkerFactory::init();
    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    QString defaultDir = QDir::searchPaths( PATH_PREFIX_DATA ).first() + "/sitecon_models";

    if (DialogUtils::getLastOpenFileDir(SiteconIO::SITECON_ID).isEmpty()) {
        DialogUtils::setLastOpenFileDir(defaultDir, SiteconIO::SITECON_ID);
    }
    
    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = SiteconAlgorithmTests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        Q_UNUSED(res);
        assert(res);
    }
}

SiteconPlugin::~SiteconPlugin() {
}


void SiteconPlugin::sl_build() {
    SiteconBuildDialogController d(this);
    d.exec();
}

void SiteconPlugin::sl_search() {
    assert(NULL);
}



SiteconADVContext::SiteconADVContext(QObject* p) : GObjectViewWindowContext(p, ANNOTATED_DNA_VIEW_FACTORY_ID)
{

}

void SiteconADVContext::initViewContext(GObjectView* view) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(view);
    ADVGlobalAction* a = new ADVGlobalAction(av, QIcon(":sitecon/images/sitecon.png"), tr("run_sitecon"), 80);
    a->addAlphabetFilter(DNAAlphabet_NUCL);
    connect(a, SIGNAL(triggered()), SLOT(sl_search()));
}

void SiteconADVContext::sl_search() {
    GObjectViewAction* action = qobject_cast<GObjectViewAction*>(sender());
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(action->getObjectView());
    
    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
    assert(seqCtx->getAlphabet()->isNucleic());
    SiteconSearchDialogController d(seqCtx);
    d.exec();
}

QList<XMLTestFactory*> SiteconAlgorithmTests::createTestFactories() {
    QList<XMLTestFactory*> res;
    res.append(GTest_CalculateACGTContent::createFactory());
    res.append(GTest_CalculateDispersionAndAverage::createFactory());
    res.append(GTest_DiPropertyCheckAttribs::createFactory());
    res.append(GTest_CalculateFirstTypeError::createFactory());
    res.append(GTest_CalculateSecondTypeError::createFactory());
    res.append(GTest_SiteconSearchTask::createFactory());
    return res;
}


}//namespace

