/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectLoaderImpl.h"

#include <core_api/AppContext.h>

#include "ProjectTasks.h"

namespace GB2 {

ProjectLoaderImpl::ProjectLoaderImpl() {
    assert(AppContext::getProject() == NULL);
	assert(AppContext::getProjectLoader() == NULL);
}

ProjectLoaderImpl::~ProjectLoaderImpl() {
    assert(AppContext::getProject() == NULL);
}

Task* ProjectLoaderImpl::openProjectTask(const QString& file, bool closeActiveProject) {
	return new OpenProjectTask(file, closeActiveProject);
}

Task* ProjectLoaderImpl::openProjectTask(const QList<QUrl>& urls, bool closeActiveProject) {
    return new OpenProjectTask(urls, closeActiveProject);
}

}//namespace

