/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectServiceImpl.h"

#include "ProjectTasks.h"
#include <core_services/AppContextImpl.h>

namespace GB2 {

ProjectServiceImpl::ProjectServiceImpl(Project* _pr) 
: ProjectService(tr("project_sname"), tr("project_sdesc"))
{
	pr = _pr;
	assert(pr!=NULL);
}

ProjectServiceImpl::~ProjectServiceImpl() {
	delete pr;
}

Task* ProjectServiceImpl::saveProjectTask(SaveProjectTaskKind k) {
	return new SaveProjectTask(k);
}

Task* ProjectServiceImpl::closeProjectTask() {
	return new CloseProjectTask();	
}

Task* ProjectServiceImpl::createServiceEnablingTask() {
	return new ProjectServiceEnableTask(this);
}

Task* ProjectServiceImpl::createServiceDisablingTask() {
	return new ProjectServiceDisableTask(this);
}

//////////////////////////////////////////////////////////////////////////
/// Service tasks

ProjectServiceEnableTask::ProjectServiceEnableTask(ProjectServiceImpl* _psi) 
: Task(tr("project_enable_task"), TaskFlag_NoRun), psi(_psi)
{}

Task::ReportResult ProjectServiceEnableTask::report() {
    AppContextImpl::getApplicationContext()->setProjectService(psi);
	AppContextImpl::getApplicationContext()->setProject(psi->getProject());

	return ReportResult_Finished;
}


ProjectServiceDisableTask::ProjectServiceDisableTask(ProjectServiceImpl* _psi) 
: Task(tr("project_disable_task"), TaskFlag_NoRun), psi(_psi)
{}

Task::ReportResult ProjectServiceDisableTask::report() {
	AppContextImpl::getApplicationContext()->setProject(NULL);
	AppContextImpl::getApplicationContext()->setProjectService(NULL);

	return ReportResult_Finished;
}

} //namespace
