/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GOBJECT_REFERENCE_H_
#define _GB2_GOBJECT_REFERENCE_H_

#include <core_api/core_api.h>

#include <QtCore/QDataStream>

namespace GB2 {

class GObject;

class GB2_COREAPI_EXPORT GObjectReference {
public:	
    GObjectReference(){}

    GObjectReference(const QString& _docUrl, const QString& _objName, const GObjectType& _type) 
        : docUrl(_docUrl), objName(_objName), objType(_type){}

    GObjectReference(const GObject* obj, bool deriveLoadedType = true);

    bool isValid() const {return !docUrl.isEmpty() && !objName.isEmpty() && !objType.isEmpty();}

    bool operator ==(const GObjectReference& o) const;

    QString     docUrl;
    QString     objName;
    GObjectType objType;
private:
    static bool registerMeta;
};

//TODO: add constraints on relation roles

class GB2_COREAPI_EXPORT GObjectRelation {
public:	
    GObjectRelation(){}

    GObjectRelation(const GObjectReference& _ref, const QString& _role, const QString& _data = QString()) 
        : ref(_ref), role(_role), data(_data){}

    bool isValid() const {return ref.isValid() && !role.isEmpty();}

    bool operator ==(const GObjectRelation& o) const;

    GObjectReference ref;
    QString         role;
    QString         data;
private:
    static bool registerMeta;
};



QDataStream &operator<<(QDataStream &out, const GObjectReference &myObj);
QDataStream &operator>>(QDataStream &in, GObjectReference &myObj);
QDataStream &operator<<(QDataStream &out, const GObjectRelation &myObj);
QDataStream &operator>>(QDataStream &in, GObjectRelation &myObj);
    

}//namespace

Q_DECLARE_METATYPE( GB2::GObjectReference )
Q_DECLARE_METATYPE( GB2::GObjectRelation )
Q_DECLARE_METATYPE( QList< GB2::GObjectReference > )
Q_DECLARE_METATYPE( QList< GB2::GObjectRelation > )

#endif
