/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <util_sec_struct_predict/SecStructPredictTask.h>
#include "SecStructPredictAlgRegistry.h"

namespace GB2 {

SecStructPredcitAlgRegistry::SecStructPredcitAlgRegistry( QObject* pOwn /*= 0*/ ) : QObject(pOwn)
{
   

}

SecStructPredcitAlgRegistry::~SecStructPredcitAlgRegistry()
{
    foreach( SecStructPredictTaskFactory* factory, algMap.values()) {
        delete factory;
    }
}

bool SecStructPredcitAlgRegistry::registerAlgorithm( SecStructPredictTaskFactory* alg, const QString& algId )
{
    QMutexLocker locker(&mutex);

    if (algMap.contains(algId)){	
        return false;
    }
    algMap.insert(algId, alg);	
    return true;

}

bool SecStructPredcitAlgRegistry::hadRegistered( const QString& algId )
{
    return algMap.contains(algId);
}

SecStructPredictTaskFactory* SecStructPredcitAlgRegistry::getAlgorithm( const QString& algId )
{
    if (algMap.contains(algId)) {
        return algMap.value(algId);
    } else {
        return NULL;
    }
}

QStringList SecStructPredcitAlgRegistry::getAlgNameList()
{
    return algMap.keys();
}

    
}


