/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEC_STRUCT_PREDICT_ALG_REGISTRY_H_
#define _GB2_SEC_STRUCT_PREDICT_ALG_REGISTRY_H_

#include <QList>
#include <QString>
#include <QMutex>
#include <QObject>

#include "core_api.h"

namespace GB2 {

class SecStructPredictTaskFactory;
class SecStructPredictTask;

class GB2_COREAPI_EXPORT SecStructPredcitAlgRegistry : public QObject {
	Q_OBJECT
public:	
	SecStructPredcitAlgRegistry(QObject* pOwn = 0);
	~SecStructPredcitAlgRegistry();
	bool registerAlgorithm(SecStructPredictTaskFactory* alg, const QString& algId);
    bool hadRegistered(const QString& algId);
    SecStructPredictTaskFactory* getAlgorithm(const QString& algId);
	QStringList getAlgNameList();
private:
	QMutex mutex;
	QMap<QString, SecStructPredictTaskFactory*> algMap;
    // Copy prohibition
    SecStructPredcitAlgRegistry(const SecStructPredcitAlgRegistry& m);
	SecStructPredcitAlgRegistry& operator=(const SecStructPredcitAlgRegistry& m);
};

} // namespace

#endif
