/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SETTINGS_H_
#define _GB2_SETTINGS_H_

#include "core_api.h"
#include "PluginModel.h"

#include <QtCore/QVariant>
#include <QtCore/QStringList>


namespace GB2 {
class GB2_COREAPI_EXPORT Settings : public QObject {
    Q_OBJECT
public:
    virtual QStringList getAllKeys(const QString& path)  = 0;

    virtual bool contains(const QString& key) const = 0;
    virtual void remove(const QString& key) = 0;

    virtual QVariant getValue(const QString& key, const QVariant& defaultValue = QVariant()) const =0;
    virtual void setValue(const QString& key, const QVariant& value)=0;

    virtual void sync()=0;
};

} //namespace
#endif
