/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SmithWatermanTaskFactoryRegistry.h"

#include <QMutexLocker>
#include <QStringList>

namespace GB2 {

SmithWatermanTaskFactoryRegistry::SmithWatermanTaskFactoryRegistry(QObject* pOwn):
	QObject(pOwn)
{
}

SmithWatermanTaskFactoryRegistry::~SmithWatermanTaskFactoryRegistry()
{
	foreach (const NamedSmithWatermanTaskFactory& ca, alg_list) {
		delete ca.alg;
	}
}

bool SmithWatermanTaskFactoryRegistry::registerAlgorithm(SmithWatermanTaskFactory* alg, const QString& alg_id)
{
	QMutexLocker locker(&mutex);

	QList<NamedSmithWatermanTaskFactory>::iterator i = findAlgorithm(alg_id);
	if (alg_list.end() != i) {	
		return false;
	}
	NamedSmithWatermanTaskFactory new_a;
	new_a.alg	 = alg;
	new_a.alg_id = alg_id;
	alg_list.append(new_a);	
	return true;
}

SmithWatermanTaskFactory* SmithWatermanTaskFactoryRegistry::getAlgorithm(const QString& alg_id)
{
	SmithWatermanTaskFactory* alg = 0;
	QList<NamedSmithWatermanTaskFactory>::iterator i = findAlgorithm(alg_id);
	if (alg_list.end() != i) {
		alg = (*i).alg;
	}
	return alg;
}

QStringList SmithWatermanTaskFactoryRegistry::getListAlgNames()
{
	QStringList res;	
	foreach (const NamedSmithWatermanTaskFactory& ca, alg_list) {
		res.append(ca.alg_id);
	}
	return res;
}

QList<NamedSmithWatermanTaskFactory>::iterator 
SmithWatermanTaskFactoryRegistry::findAlgorithm(const QString& alg_id)
{
	QList<NamedSmithWatermanTaskFactory>::iterator i;
	for (i = alg_list.begin(); i != alg_list.end(); ++i) {
		if ((*i).alg_id == alg_id) {
			return i;
		}
	}
	return alg_list.end();
}

bool SmithWatermanTaskFactoryRegistry::hadRegistered(const QString& alg_id) {
    return alg_list.end() != findAlgorithm(alg_id);
}

} // namespace
