/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SUBST_MATRIX_REGISTRY_H_
#define _GB2_SUBST_MATRIX_REGISTRY_H_

#include <core_api/core_api.h>
#include <core_api/DNAAlphabet.h>

#include <QList>
#include <QMutex>
#include <QDir>
#include <QApplication>
#include <QString>
#include <QStringList>

#include <util_smith_waterman/SubstMatrix.h>

namespace GB2 {

struct NamedSubstMatrix {
	QString mtx_id;
	const SubstMatrix* mtx;
};

typedef QList<NamedSubstMatrix>::iterator		mtx_list_iterator;
typedef QList<NamedSubstMatrix>::const_iterator mtx_list_const_iterator;

class GB2_COREAPI_EXPORT SubstMatrixRegistry : public QObject {
	Q_OBJECT
public:
	SubstMatrixRegistry(QObject* pOwn = 0);
	~SubstMatrixRegistry();
	
	const SubstMatrix* getSubstMatrix(const QString& mtx_id);
	bool registerSubstMatrix(const QString& fileName);
	bool hadRegistered(const QString& mtx_id);

	QStringList getListMatrixNames();
	QStringList findMatricesByAlphabet(DNAAlphabet* al);
	void dump() const;
private:
	QMutex mutex;
	QList<NamedSubstMatrix> mtx_list;
	mtx_list_iterator findSubstMatrix(const QString& mtx_id);
};

} // namespace

#endif
