/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_COREAPI_H_
#define _GB2_COREAPI_H_

#include <assert.h>
#include <Qt/qglobal.h>
#include <QtCore/QVariantMap>
#include <QtCore/QObject>

#ifdef _GB2_CORE_BUILD_DLL_
    #define GB2_COREAPI_EXPORT Q_DECL_EXPORT
#else
    #define GB2_COREAPI_EXPORT Q_DECL_IMPORT
#endif
//global
#define GLOBAL_SETTINGS QString("global/")

// menu 
#define MWMENU_FILE							"mwmenu_file"
#define MWMENU_ACTIONS						"mwmenu_actions"
#define MWMENU_SETTINGS						"mwmenu_settings"
#define MWMENU_TOOLS						"mwmenu_tools"
#define MWMENU_WINDOW						"mwmenu_window"
#define MWMENU_HELP							"mwmenu_help"



// toolbar
#define MWTOOLBAR_MAIN						"mwtoolbar_main"
#define MWTOOLBAR_ACTIVEMDI					"mwtoolbar_activemdi"



//actions
#define ACTION__EXIT			"action__exit"
#define ACTION__ABOUT			"action__about"
#define ACTION__LOGVIEW			"action__logview"
#define ACTION__PLUGINS_VIEW    "action__plugins"

#define ACTION_PROJECTSUPPORT__NEW_PROJECT				"action_projectsupport__new_project"
#define ACTION_PROJECTSUPPORT__OPEN_PROJECT				"action_projectsupport__open_project"
#define ACTION_PROJECTSUPPORT__SAVE_PROJECT				"action_projectsupport__save_project"
#define ACTION_PROJECTSUPPORT__CLOSE_PROJECT			"action_projectsupport__close_project"
#define ACTION_PROJECTSUPPORT__RECENT_PROJECTS_MENU		"action_projectsupport__recent_projects_menu"

#define ACTION_PROJECT__ADD_MENU					"action_project__add_menu"
#define ACTION_PROJECT__ADD_NEW_DOCUMENT			"action_project__add_new_document"
#define ACTION_PROJECT__ADD_EXISTING_DOCUMENT		"action_project__add_existing_document"

#define DOCK_PROJECT_VIEW    "dock_project_view"
#define DOCK_TASK_VIEW       "dock_task_view"
#define DOCK_LOG_VIEW        "dock_log_view"


#ifdef Q_OS_WIN
    #define PLUGIN_FILE_EXT "dll"
#elif defined Q_OS_MAC
    #define PLUGIN_FILE_EXT "dylib"
#else 
    #define PLUGIN_FILE_EXT "so"
#endif

#define ENV_UGENE_DEV "UGENE_DEV"

#define PATH_PREFIX_DATA "data"
#define PATH_PREFIX_SCRIPTS "scripts"

typedef QMap<QString, QString> QStrStrMap;

namespace GB2 {

//internal types:
typedef QString                 DocumentFormatId;
typedef QString                 GObjectType;
typedef QString                 IOAdapterId;
typedef QString                 GObjectViewFactoryId;
typedef QString                 GTestFormatId;

enum TriState {
    TriState_Unknown,
    TriState_Yes,
    TriState_No
};

enum UnloadedObjectFilter { //used as a separate type but not 'bool' to improve readability
    UOF_LoadedAndUnloaded,
    UOF_LoadedOnly
};

}

enum DNAAlphabetType {
    DNAAlphabet_RAW,
    DNAAlphabet_NUCL,
    DNAAlphabet_AMINO
};



#endif
