/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_INDEX_FORMAT_H_
#define _GB2_INDEX_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class GB2_COREAPI_EXPORT IndexFormat : public DocumentFormat {
    Q_OBJECT
public:
    static const int OBJECTS_IN_DOC = 1;
    
    static const QByteArray FILE_HEADER;
    static const QString WRITE_LOCK_REASON;

private:
    QString format_name;
    
public:
    IndexFormat( QObject* obj );
    
    virtual DocumentFormatId getFormatId() const {
        return BaseDocumentFormats::INDEX;
    }

    virtual const QString& getFormatName() const {
        return format_name;
    }

    virtual QStringList getSupportedDocumentFileExtensions();

    virtual Document* loadExistingDocument( IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs );

    virtual void storeDocument( Document* d, TaskStateInfo& ti, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null );

    virtual bool isDataFormatSupported( const char* data, int size ) const;

    virtual bool isObjectOpSupported( const Document* d , DocumentFormat::DocObjectOp op, GObjectType t ) const;

    virtual bool checkConstraints( const DocumentFormatConstraints& c ) const;

    struct IndexFormatException {
    QString msg;
    IndexFormatException( const QString& what ) : msg( what ){}
    };
    
    struct ReadError : public IndexFormatException {
        ReadError() : IndexFormatException( tr( "Read error occurred" ) ){}
    };
    
    struct BadDataError : public IndexFormatException {
        BadDataError( const QString& what ) : IndexFormatException( what ){}
    };
    
    struct WriteError : public IndexFormatException {
        WriteError() : IndexFormatException( tr( "Write error occurred" ) ){}
    };
    
}; // IndexFormat

} // GB2

#endif // _GB2_INDEX_FORMAT_H_
