/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_CHROMATOGRAM_OBJECT_H_
#define _GB2_DNA_CHROMATOGRAM_OBJECT_H_

#include <core_api/GObject.h>
#include <datatype/DNAChromatogram.h>

namespace GB2 {

class  GB2_COREAPI_EXPORT DNAChromatogramObject: public GObject {
    Q_OBJECT
public:
    DNAChromatogramObject(const DNAChromatogram& chrom, const QString& objectName, const QVariantMap& hints = QVariantMap());

    const DNAChromatogram& getChromatogram() const {return chrom;}

    virtual GObject* clone() const;

protected:
    DNAChromatogram chrom;
};

}//namespace


#endif
