/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "GObjectTypes.h"
#include <core_api/GObject.h>

/* TRANSLATOR GB2::GObject */

namespace GB2 {

GObjectTypeInfo::GObjectTypeInfo(const GObjectType& _type, const QString& _name, const QString& _pluralName, 
                                 const QString& _treeSign, const QString _iconURL)
: type(_type), name(_name), pluralName(_pluralName), treeSign(_treeSign), iconURL(_iconURL)
{
}

#define REGISTER_TYPE_EX(VAR, ID, NAME, P_NAME, SIGN, ICON_URI) \
    const GObjectType GObjectTypes::VAR = registerTypeInfo(GObjectTypeInfo(ID, NAME, P_NAME, SIGN, ICON_URI))

#define REGISTER_TYPE(VAR, ID, NAME, P_NAME, SIGN) \
    REGISTER_TYPE_EX(VAR, ID, NAME, P_NAME, SIGN, "")

///            variable             id                  visual name                     plural name                    sign     icon
REGISTER_TYPE(UNKNOWN,              "OT_UNKNOWN",       GObject::tr("Unknown"),         GObject::tr("Unknown"),        "?");
REGISTER_TYPE(UNLOADED,             "OT_UNLOADED",      GObject::tr("Unloaded"),        GObject::tr("Unloaded"),       "u");
REGISTER_TYPE_EX(TEXT,              "OT_TEXT",          GObject::tr("Text"),            GObject::tr("Text"),           "t",     ":core/images/texto.png");
REGISTER_TYPE(DNA_SEQUENCE,         "OT_SEQUENCE",      GObject::tr("Sequence"),        GObject::tr("Sequences"),      "s");
REGISTER_TYPE(ANNOTATION_TABLE,     "OT_ANNOTATIONS",   GObject::tr("Annotation"),      GObject::tr("Annotations"),    "a");
REGISTER_TYPE(DNA_CHROMATOGRAM,     "OT_CHROMATOGRAM",  GObject::tr("Chromatogram"),    GObject::tr("Chromatograms"),  "c");
REGISTER_TYPE(MULTIPLE_ALIGNMENT,   "OT_MSA",           GObject::tr("Alignment"),       GObject::tr("Alignments"),     "m");
REGISTER_TYPE(PHYLOGENETIC_TREE,    "OT_PTREE",         GObject::tr("Tree"),            GObject::tr("Trees"),          "t");
REGISTER_TYPE_EX(BIOSTRUCTURE_3D,   "OT_BIOSTRUCT3D",   GObject::tr("3D model"),        GObject::tr("3D models"),      "3d",    ":core/images/biostruct3d.png");
REGISTER_TYPE_EX(UINDEX,            "OT_INDEX",         GObject::tr("Index"),           GObject::tr("Indexes"),        "i",     ":core/images/table.png");

static QHash<GObjectType, GObjectTypeInfo>& getTypeMap() {
    static QHash<GObjectType, GObjectTypeInfo> map;
    return map;
}

const GObjectTypeInfo& GObjectTypes::getTypeInfo(const QString& t) {
    QHash<GObjectType, GObjectTypeInfo>& m = getTypeMap();
    if (m.contains(t)) {
        GObjectTypeInfo& r = m[t];
        return r;
    }
    GObjectTypeInfo& r = m[GObjectTypes::UNKNOWN];
    return r;
}

GObjectType GObjectTypes::registerTypeInfo(const GObjectTypeInfo& ti) {
    QHash<GObjectType, GObjectTypeInfo>& map = getTypeMap();
    assert(!map.contains(ti.type));
    map[ti.type] = ti;
    return ti.type;
}

void GObjectTypes::initTypeTranslations() {
    QHash<GObjectType, GObjectTypeInfo>& map = getTypeMap();
    foreach(GObjectType t, map.keys()) {
        GObjectTypeInfo& info = map[t];
        info.name = GObject::tr(info.name.toLocal8Bit().data());
        info.pluralName = GObject::tr(info.pluralName.toLocal8Bit().data());
    }
}

void GObjectTypes::initTypeIcons() {
    QHash<GObjectType, GObjectTypeInfo>& map = getTypeMap();
    foreach(GObjectType t, map.keys()) {
        GObjectTypeInfo& info = map[t];
        if (!info.iconURL.isEmpty()) {
            info.icon = QIcon(info.iconURL);
        } else {
            info.icon = QIcon(":/core/images/gobject.png");
        }
    }
}

}//namespace


