/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_XML_TEST_FORMAT_H_
#define _GB2_XML_TEST_FORMAT_H_

#include "../GTest.h"

namespace GB2 {

class XMLTestFormat;

class GB2_COREAPI_EXPORT XMLTestFactory {
public:
    XMLTestFactory(const QString& _tagName) : tagName(_tagName){}
    virtual ~XMLTestFactory();

    virtual GTest* createTest(XMLTestFormat* tf, const QString& testName, GTest* cp, const GTestEnvironment* env, 
                              const QList<GTest*>& subtasks, const QDomElement& el) = 0;

    const QString& getTagName() const {return tagName;}

private:
    QString tagName;
};

class GB2_COREAPI_EXPORT XMLTestFormat : public GTestFormat {
    Q_OBJECT
public:
    XMLTestFormat();
    virtual ~XMLTestFormat();
    
    virtual GTest* createTest(const QString& name, GTest* cp, const GTestEnvironment* env, const QByteArray& testData, QString& err);
    
    virtual GTest* createTest(const QString& name, GTest* cp, const GTestEnvironment* env, const QDomElement& el, QString& err);

    virtual bool registerTestFactory(XMLTestFactory* tf);

    virtual bool unregisterTestFactory(XMLTestFactory* tf);

private:
    void registerBuiltInFactories();
    QMap<QString, XMLTestFactory*> testFactories;
};

}//namespace

#endif
