/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AddPartToSequenceDialogController.h"

#include <core_api/Log.h>
#include <core_api/DocumentFormats.h>
#include <core_api/AppContext.h>

#include <QtGui/QMessageBox>
#include <QtCore/QFileInfo>
#include <QtCore/QDir>
#include <QtGui/QFileDialog>


namespace GB2{

static LogCategory log(ULOG_CAT_USER_INTERFACE);

AddPartToSequenceDialogController::AddPartToSequenceDialogController(LRegion _source, DNAAlphabet *_alph, QWidget *p, int _pos)
:QDialog(p), filter(""), pos(_pos), source(_source){
    setupUi(this);

    connect(browseButton, SIGNAL(clicked()), SLOT(sl_browseButtonClicked()));
    addSeqpasterWidget();
    w->disableCustomSettings();
    w->setPreferredAlphabet(_alph);

    insertPositionSpin->setMinimum(0);
    insertPositionSpin->setMaximum(source.len);

    connect(formatBox, SIGNAL(currentIndexChanged(int)), this, SLOT(sl_indexChanged(int)));

    formatBox->addItem("FASTA", BaseDocumentFormats::PLAIN_FASTA);
    formatBox->addItem("Genbank", BaseDocumentFormats::PLAIN_GENBANK);
    connect(mergeAnnotationsBox, SIGNAL(toggled(bool)), this, SLOT(sl_mergeAnnotationsToggled(bool)));
    sl_indexChanged(0);
}

void AddPartToSequenceDialogController::accept(){
    QString validationError = w->validate();
    if(!validationError.isEmpty()){
        QMessageBox::critical(this, this->windowTitle(), validationError);
        return;
    }
    if(!modifyCurrentDocument()){
        QFileInfo fi(filepathEdit->text());
        QDir dirToSave(fi.dir());
        if (!dirToSave.exists()){
            QMessageBox::critical(this, this->windowTitle(), tr("Directory to save is not exists"));
            return;
        }
        if(filepathEdit->text().isEmpty()){
            QMessageBox::critical(this, this->windowTitle(), tr("Entered path is empty"));
            return;
        }
        if(fi.baseName().isEmpty()){
            QMessageBox::critical(this, this->windowTitle(), tr("Filename to save is empty"));
            return;
        }
    }
    pos = insertPositionSpin->value();

    this->close();
    QDialog::accept();
}

void AddPartToSequenceDialogController::addSeqpasterWidget(){
    w = new SeqPasterWidgetController(this);
    QWidget* caw = w->getWidget();    
    QVBoxLayout* l = new QVBoxLayout();
    l->setMargin(0);
    l->addWidget(caw);
    seqPaster->setLayout(l);
    seqPaster->setMinimumSize(caw->layout()->minimumSize());   
}

void AddPartToSequenceDialogController::sl_browseButtonClicked(){
    LastOpenDirHelper h;
    
    QString newPath = QFileDialog::getSaveFileName(this, tr("Select file to save..."), h.dir, filter);
    filepathEdit->setText(newPath);
}

AddPartToSequenceTask::AnnotationStrategyForAdd AddPartToSequenceDialogController::getStrategy(){
    if(resizeRB->isChecked()){
        return AddPartToSequenceTask::AnnotationStrategyForAdd_Resize;
    }else if(splitRB->isChecked()){
        return AddPartToSequenceTask::AnnotationStrategyForAdd_Split;
    }else{
        assert(removeRB->isChecked());
        return AddPartToSequenceTask::AnnotationStrategyForAdd_Remove;
    }
}

void AddPartToSequenceDialogController::sl_indexChanged( int index){
    DocumentFormatId currentId = (formatBox->itemData(index)).toString();
    filter = DialogUtils::prepareDocumentsFileFilter(currentId, false);
    DocumentFormat *df = AppContext::getDocumentFormatRegistry()->getFormatById(currentId);
    QString newExt = df->getSupportedDocumentFileExtensions().first();
    QString filepath = filepathEdit->text();
    if (filepath.isEmpty()){
        return;
    }
    QFileInfo fi(filepath);
    filepathEdit->setText(fi.absoluteDir().absolutePath() + "/" + fi.baseName() + "." + newExt);
}

void AddPartToSequenceDialogController::sl_mergeAnnotationsToggled( bool state){
    Q_UNUSED(state);
    if(mergeAnnotationsBox->isChecked()){
        sl_indexChanged(formatBox->findText("Genbank"));
        formatBox->removeItem(formatBox->findText("FASTA"));
    }else{
        formatBox->addItem("FASTA", BaseDocumentFormats::PLAIN_FASTA);
    }
}

}//ns

