/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADV_SPLIT_WIDGET_H_
#define _GB2_ADV_SPLIT_WIDGET_H_

#include <core_api/core_api.h>
#include <QtGui/QSplitter>

namespace GB2 {
    

class AnnotatedDNAView;
class GObject;

class GB2_COREAPI_EXPORT ADVSplitWidget : public QWidget {
    Q_OBJECT
public:
    ADVSplitWidget(AnnotatedDNAView* view) : dnaView(view) { }
    AnnotatedDNAView* getAnnotatedDNAView() const {return dnaView;}
    virtual bool acceptsGObject(GObject* objects)  = 0;
    virtual void updateState(const QVariantMap& m) = 0;
    virtual void saveState(QVariantMap& m) = 0;
protected:
    AnnotatedDNAView* dnaView;
};


}//namespace

#endif //_GB2_ADV_SPLIT_WIDGET_H_
