/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MSAEditorConsensusCache.h"

#include <gobjects/MAlignmentObject.h>
#include <util_algorithm/MSAUtils.h>

namespace GB2 {

MSAEditorConsensusCache::MSAEditorConsensusCache(QObject* p, MAlignmentObject* o) 
: QObject(p), currentVersion(1), aliObj(o)
{
    connect(aliObj, SIGNAL(si_alignmentChanged(const MAlignment&, const MAlignmentModInfo&)), 
        SLOT(sl_alignmentChanged(const MAlignment&, const MAlignmentModInfo&)));

    cache.resize(aliObj->getMAlignment().getLength());
}

void MSAEditorConsensusCache::sl_alignmentChanged(const MAlignment&, const MAlignmentModInfo&) {
    cache.resize(aliObj->getMAlignment().getLength());
    currentVersion++;
}

void MSAEditorConsensusCache::updateCacheItem(int pos) {
    const MAlignment& ma = aliObj->getMAlignment();
    assert(pos >= 0 && pos < ma.getLength());
    assert(pos < cache.size() && cache.size() == ma.getLength());
    const CacheItem& cci = cache[pos];
    if (cci.version == currentVersion) {
        return;
    }
    CacheItem& ci = cache[pos];
    int count = 0;
    int nSeq = ma.getNumSequences();
    MSAUtils::getConsensusCharAndCount(ma, pos, ci.topChar, count);
    if (count != nSeq && (ci.topChar>='A' && ci.topChar<='Z')) {
        ci.topChar = ci.topChar + ('a'-'A');
    }
    ci.topPercent = (char)qRound(count * 100 / nSeq);
    assert(ci.topPercent >=0 && ci.topPercent<=100);
    ci.version = currentVersion;
}

char MSAEditorConsensusCache::getConsensusChar(int pos) {
    updateCacheItem(pos);
    const CacheItem& ci = cache[pos];
    return ci.topChar;
}

int MSAEditorConsensusCache::getConsensusCharPercent(int pos) {
    updateCacheItem(pos);
    const CacheItem& ci = cache[pos];
    return ci.topPercent;
}

QString MSAEditorConsensusCache::getConsensusLine() {
    QString res;
    const MAlignment& ma = aliObj->getMAlignment();
    for (int i=0, n = ma.getLength(); i<n; i++) {
        char c = getConsensusChar(i);
        if (c!=MAlignment_GapChar) {
            res.append(c);
        }
    }
    return res;
}


}//namespace

